/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.StringUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewritePomsForReleasePhase
extends AbstractRewritePomsPhase {
    private Map<String, ScmTranslator> scmTranslators;

    @Override
    protected void transformScm(MavenProject project, Element rootElement, Namespace namespace, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result, String commonBasedir) throws ReleaseExecutionException {
        if (project.getScm() != null) {
            Element scmRoot = rootElement.getChild("scm", namespace);
            if (scmRoot != null) {
                Scm scm = this.buildScm(project);
                releaseDescriptor.mapOriginalScmInfo(projectId, scm);
                try {
                    this.translateScm(project, releaseDescriptor, scmRoot, namespace, scmRepository, result, commonBasedir);
                }
                catch (IOException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
            releaseDescriptor.mapOriginalScmInfo(projectId, null);
            MavenProject parent = project.getParent();
            if (parent != null) {
                String parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
                if (!releaseDescriptor.getOriginalScmInfo().containsKey(parentId)) {
                    scmRoot = new Element("scm");
                    scmRoot.addContent("\n  ");
                    try {
                        if (this.translateScm(project, releaseDescriptor, scmRoot, namespace, scmRepository, result, commonBasedir)) {
                            rootElement.addContent("\n  ").addContent((Content)scmRoot).addContent("\n");
                        }
                    }
                    catch (IOException e) {
                        throw new ReleaseExecutionException(e.getMessage(), e);
                    }
                }
            }
        }
    }

    private boolean translateScm(MavenProject project, ReleaseDescriptor releaseDescriptor, Element scmRoot, Namespace namespace, ScmRepository scmRepository, ReleaseResult relResult, String commonBasedir) throws IOException {
        ScmTranslator translator = this.scmTranslators.get(scmRepository.getProvider());
        boolean result = false;
        if (translator != null) {
            String value;
            String value2;
            String trunkUrl;
            String subDirectoryTag;
            String rootUrl;
            Scm scm = project.getOriginalModel().getScm();
            if (scm == null) {
                scm = project.getScm();
            }
            String tag = releaseDescriptor.getScmReleaseLabel();
            String tagBase = releaseDescriptor.getScmTagBase();
            if (tagBase != null) {
                tagBase = "scm:svn:" + tagBase;
            }
            String workingDirectory = ReleaseUtil.isSymlink(project.getBasedir()) ? project.getBasedir().getCanonicalPath() : project.getBasedir().getAbsolutePath();
            int count = ReleaseUtil.getBaseWorkingDirectoryParentCount(commonBasedir, workingDirectory);
            if (scm.getConnection() != null) {
                String scmConnectionTag;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getConnection());
                subDirectoryTag = scm.getConnection().substring(rootUrl.length());
                if (!subDirectoryTag.startsWith("/")) {
                    subDirectoryTag = "/" + subDirectoryTag;
                }
                if ((scmConnectionTag = tagBase) != null) {
                    trunkUrl = scm.getDeveloperConnection();
                    if (trunkUrl == null) {
                        trunkUrl = scm.getConnection();
                    }
                    scmConnectionTag = this.translateUrlPath(trunkUrl, tagBase, scm.getConnection());
                }
                if (!(value2 = translator.translateTagUrl(scm.getConnection(), tag + subDirectoryTag, scmConnectionTag)).equals(scm.getConnection())) {
                    this.rewriteElement("connection", value2, scmRoot, namespace);
                    result = true;
                }
            }
            if (scm.getDeveloperConnection() != null) {
                String value3;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getDeveloperConnection());
                subDirectoryTag = scm.getDeveloperConnection().substring(rootUrl.length());
                if (!subDirectoryTag.startsWith("/")) {
                    subDirectoryTag = "/" + subDirectoryTag;
                }
                if (!(value3 = translator.translateTagUrl(scm.getDeveloperConnection(), tag + subDirectoryTag, tagBase)).equals(scm.getDeveloperConnection())) {
                    this.rewriteElement("developerConnection", value3, scmRoot, namespace);
                    result = true;
                }
            }
            if (scm.getUrl() != null) {
                String tagScmUrl;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getUrl());
                subDirectoryTag = scm.getUrl().substring(rootUrl.length());
                if (!subDirectoryTag.startsWith("/")) {
                    subDirectoryTag = "/" + subDirectoryTag;
                }
                if ((tagScmUrl = tagBase) != null) {
                    trunkUrl = scm.getDeveloperConnection();
                    if (trunkUrl == null) {
                        trunkUrl = scm.getConnection();
                    }
                    tagScmUrl = this.translateUrlPath(trunkUrl, tagBase, scm.getUrl());
                }
                if (!(value2 = translator.translateTagUrl(scm.getUrl(), tag + subDirectoryTag, tagScmUrl)).equals(scm.getUrl())) {
                    this.rewriteElement("url", value2, scmRoot, namespace);
                    result = true;
                }
            }
            if (tag != null && (value = translator.resolveTag(tag)) != null && !value.equals(scm.getTag())) {
                this.rewriteElement("tag", value, scmRoot, namespace);
                result = true;
            }
        } else {
            String message = "No SCM translator found - skipping rewrite";
            relResult.appendDebug(message);
            this.getLogger().debug(message);
        }
        return result;
    }

    @Override
    protected Map<String, String> getOriginalVersionMap(ReleaseDescriptor releaseDescriptor, List<MavenProject> reactorProjects, boolean simulate) {
        return releaseDescriptor.getOriginalVersions(reactorProjects);
    }

    @Override
    protected Map<String, String> getNextVersionMap(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getReleaseVersions();
    }

    @Override
    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, Map<String, Map<String, String>> resolvedSnapshotsMap) {
        Map<String, String> versionsMap = resolvedSnapshotsMap.get(artifactVersionlessKey);
        if (versionsMap != null) {
            return versionsMap.get("rel");
        }
        return null;
    }

    private String translateUrlPath(String trunkPath, String tagPath, String urlPath) {
        int i;
        trunkPath = trunkPath.trim();
        tagPath = tagPath.trim();
        if (trunkPath.endsWith("/")) {
            trunkPath = trunkPath.substring(0, trunkPath.length() - 1);
        }
        if (tagPath.endsWith("/")) {
            tagPath = tagPath.substring(0, tagPath.length() - 1);
        }
        char[] tagPathChars = trunkPath.toCharArray();
        char[] trunkPathChars = tagPath.toCharArray();
        for (i = 0; i < tagPathChars.length && i < trunkPathChars.length && tagPathChars[i] == trunkPathChars[i]; ++i) {
        }
        if (i == 0 || urlPath.indexOf(trunkPath.substring(i)) < 0) {
            return tagPath;
        }
        return StringUtils.replace((String)urlPath, (String)trunkPath.substring(i), (String)tagPath.substring(i));
    }
}

