/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckPomPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        if (StringUtils.isEmpty((String)releaseDescriptor.getScmSourceUrl())) {
            MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
            if (rootProject != null && rootProject.getScm() != null) {
                if (rootProject.getScm().getDeveloperConnection() != null) {
                    releaseDescriptor.setScmSourceUrl(rootProject.getScm().getDeveloperConnection());
                } else if (rootProject.getScm().getConnection() != null) {
                    releaseDescriptor.setScmSourceUrl(rootProject.getScm().getConnection());
                }
            }
            if (StringUtils.isEmpty((String)releaseDescriptor.getScmSourceUrl())) {
                throw new ReleaseFailureException("Missing required setting: scm connection or developerConnection must be specified.");
            }
            releaseDescriptor.setScmId(rootProject.getProperties().getProperty("project.scm.id"));
            try {
                this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            }
            catch (ScmRepositoryException e) {
                throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
            }
            catch (NoSuchScmProviderException e) {
                throw new ReleaseFailureException("The provider given in the SCM URL could not be found: " + e.getMessage());
            }
        }
        boolean containsSnapshotProjects = false;
        for (MavenProject project : reactorProjects) {
            if (!ArtifactUtils.isSnapshot((String)project.getVersion())) continue;
            containsSnapshotProjects = true;
        }
        if (!containsSnapshotProjects && !releaseDescriptor.isBranchCreation()) {
            throw new ReleaseFailureException("You don't have a SNAPSHOT project in the reactor projects list.");
        }
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }
}

