/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestSuiteXmlParser
extends DefaultHandler {
    private ReportTestSuite defaultSuite;
    private ReportTestSuite currentSuite;
    private Map classesToSuites;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private StringBuffer currentElement;
    private ReportTestCase testCase;

    public Collection parse(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        this.classesToSuites = new HashMap();
        saxParser.parse(new File(xmlPath), (DefaultHandler)this);
        if (this.currentSuite != this.defaultSuite && this.defaultSuite.getNumberOfTests() == 0) {
            this.classesToSuites.remove(this.defaultSuite.getFullClassName());
        }
        return this.classesToSuites.values();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if ("testsuite".equals(qName)) {
                this.currentSuite = this.defaultSuite = new ReportTestSuite();
                Number time = this.numberFormat.parse(attributes.getValue("time"));
                this.defaultSuite.setTimeElapsed(time.floatValue());
                if (attributes.getValue("group") != null && !"".equals(attributes.getValue("group"))) {
                    String packageName = attributes.getValue("group");
                    String name = attributes.getValue("name");
                    this.defaultSuite.setFullClassName(packageName + "." + name);
                } else {
                    String fullClassName = attributes.getValue("name");
                    this.defaultSuite.setFullClassName(fullClassName);
                }
                this.classesToSuites.put(this.defaultSuite.getFullClassName(), this.defaultSuite);
            } else if ("testcase".equals(qName)) {
                this.currentElement = new StringBuffer();
                this.testCase = new ReportTestCase();
                this.testCase.setName(attributes.getValue("name"));
                String fullClassName = attributes.getValue("classname");
                if (fullClassName != null) {
                    this.currentSuite = (ReportTestSuite)this.classesToSuites.get(fullClassName);
                    if (this.currentSuite == null) {
                        this.currentSuite = new ReportTestSuite();
                        this.currentSuite.setFullClassName(fullClassName);
                        this.classesToSuites.put(fullClassName, this.currentSuite);
                    }
                }
                this.testCase.setFullClassName(this.currentSuite.getFullClassName());
                this.testCase.setClassName(this.currentSuite.getName());
                this.testCase.setFullName(this.currentSuite.getFullClassName() + "." + this.testCase.getName());
                String timeAsString = attributes.getValue("time");
                Number time = new Integer(0);
                if (timeAsString != null) {
                    time = this.numberFormat.parse(timeAsString);
                }
                this.testCase.setTime(time.floatValue());
                if (this.currentSuite != this.defaultSuite) {
                    this.currentSuite.setTimeElapsed(time.floatValue() + this.currentSuite.getTimeElapsed());
                }
            } else if ("failure".equals(qName)) {
                this.testCase.addFailure(attributes.getValue("message"), attributes.getValue("type"));
                this.currentSuite.setNumberOfFailures(1 + this.currentSuite.getNumberOfFailures());
            } else if ("error".equals(qName)) {
                this.testCase.addFailure(attributes.getValue("message"), attributes.getValue("type"));
                this.currentSuite.setNumberOfErrors(1 + this.currentSuite.getNumberOfErrors());
            } else if ("skipped".equals(qName)) {
                this.testCase.addFailure("skipped", "skipped");
                this.currentSuite.setNumberOfSkipped(1 + this.currentSuite.getNumberOfSkipped());
            }
        }
        catch (ParseException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("testcase".equals(qName)) {
            this.currentSuite.getTestCases().add(this.testCase);
        } else if ("failure".equals(qName)) {
            Map failure = this.testCase.getFailure();
            failure.put("detail", this.parseCause(this.currentElement.toString()));
        } else if ("error".equals(qName)) {
            Map error = this.testCase.getFailure();
            error.put("detail", this.parseCause(this.currentElement.toString()));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (!"".equals(s.trim())) {
            this.currentElement.append(s);
        }
    }

    private List parseCause(String detail) {
        String fullName = this.testCase.getFullName();
        String name = fullName.substring(fullName.lastIndexOf(".") + 1);
        return this.parseCause(detail, name);
    }

    private List parseCause(String detail, String compareTo) {
        StringTokenizer stringTokenizer = new StringTokenizer(detail, "\n");
        ArrayList<String> parsedDetail = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String lineString = stringTokenizer.nextToken().trim();
            parsedDetail.add(lineString);
            if (lineString.indexOf(compareTo) < 0) continue;
            break;
        }
        return parsedDetail;
    }
}

