/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.site.Menu;
import org.apache.maven.doxia.site.MenuItem;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DocumentRenderingContext;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.descriptor.AbstractSiteDescriptorMojo;
import org.apache.maven.plugins.site.render.CategorySummaryDocumentRenderer;
import org.apache.maven.plugins.site.render.ReportDocumentRenderer;
import org.apache.maven.plugins.site.render.SitemapDocumentRenderer;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.reporting.exec.MavenReportExecutor;
import org.apache.maven.reporting.exec.MavenReportExecutorRequest;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.ReaderFactory;

public abstract class AbstractSiteRenderingMojo
extends AbstractSiteDescriptorMojo {
    @Parameter
    private Map<String, String> moduleExcludes;
    @Parameter
    private Map<String, Object> attributes;
    @Component
    protected SiteRenderer siteRenderer;
    @Parameter(alias="workingDirectory", defaultValue="${project.build.directory}/generated-site")
    protected File generatedSiteDirectory;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${project.reporting}", readonly=true)
    private Reporting reporting;
    @Parameter(property="generateProjectInfo", defaultValue="true")
    private boolean generateProjectInfo;
    @Parameter(property="generateSitemap", defaultValue="false")
    private boolean generateSitemap;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String inputEncoding;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;
    @Component
    protected MavenReportExecutor mavenReportExecutor;
    @Parameter
    private boolean saveProcessedContent;

    protected String getInputEncoding() {
        return this.inputEncoding == null || this.inputEncoding.isEmpty() ? ReaderFactory.FILE_ENCODING : this.inputEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    protected void checkInputEncoding() {
        if (this.inputEncoding == null || this.inputEncoding.isEmpty()) {
            this.getLog().warn((CharSequence)("Input file encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
    }

    protected List<MavenReportExecution> getReports(File outputDirectory) throws MojoExecutionException {
        MavenReportExecutorRequest mavenReportExecutorRequest = new MavenReportExecutorRequest();
        mavenReportExecutorRequest.setMavenSession(this.mavenSession);
        mavenReportExecutorRequest.setExecutionId(this.mojoExecution.getExecutionId());
        mavenReportExecutorRequest.setProject(this.project);
        mavenReportExecutorRequest.setReportPlugins(this.getReportingPlugins());
        List allReports = this.mavenReportExecutor.buildMavenReports(mavenReportExecutorRequest);
        ArrayList<MavenReportExecution> reportExecutions = new ArrayList<MavenReportExecution>(allReports.size());
        for (MavenReportExecution exec : allReports) {
            String reportMojoInfo = exec.getPlugin().getId() + ":" + exec.getGoal();
            exec.getMavenReport().setReportOutputDirectory(outputDirectory);
            try {
                if (exec.canGenerateReport()) {
                    reportExecutions.add(exec);
                    continue;
                }
                if (!exec.isUserDefined()) continue;
                this.getLog().info((CharSequence)("Skipping " + reportMojoInfo + " report"));
            }
            catch (MavenReportException e) {
                throw new MojoExecutionException("Failed to determine whether report '" + reportMojoInfo + "' can be generated", (Exception)((Object)e));
            }
        }
        return reportExecutions;
    }

    private ReportPlugin[] getReportingPlugins() {
        List reportingPlugins = this.reporting.getPlugins();
        boolean hasMavenProjectInfoReportsPlugin = false;
        for (ReportPlugin plugin : reportingPlugins) {
            if (!"org.apache.maven.plugins".equals(plugin.getGroupId()) || !"maven-project-info-reports-plugin".equals(plugin.getArtifactId())) continue;
            hasMavenProjectInfoReportsPlugin = true;
            break;
        }
        if (!this.reporting.isExcludeDefaults() && !hasMavenProjectInfoReportsPlugin) {
            ReportPlugin mpir = new ReportPlugin();
            mpir.setArtifactId("maven-project-info-reports-plugin");
            reportingPlugins.add(mpir);
        }
        return reportingPlugins.toArray(new ReportPlugin[0]);
    }

    protected SiteRenderingContext createSiteRenderingContext(Locale locale) throws MojoExecutionException, IOException, MojoFailureException {
        SiteRenderingContext context;
        SiteModel siteModel = this.prepareSiteModel(locale);
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        templateProperties.put("project", this.project);
        templateProperties.put("inputEncoding", this.getInputEncoding());
        templateProperties.put("outputEncoding", this.getOutputEncoding());
        for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
            templateProperties.put((String)entry.getKey(), entry.getValue());
        }
        if (this.attributes != null) {
            templateProperties.putAll(this.attributes);
        }
        try {
            Artifact skinArtifact = this.siteTool.getSkinArtifactFromRepository(this.repoSession, this.remoteProjectRepositories, siteModel.getSkin());
            this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"Rendering content with ").strong((Object)(skinArtifact.getId() + " skin")).build());
            context = this.siteRenderer.createContextForSkin(skinArtifact, templateProperties, siteModel, this.project.getName(), locale);
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("Failed to retrieve skin artifact from repository", (Exception)((Object)e));
        }
        catch (RendererException e) {
            throw new MojoExecutionException("Failed to create context for skin", (Exception)((Object)e));
        }
        MavenArchiver.parseBuildOutputTimestamp((String)this.outputTimestamp).ifPresent(v -> context.setPublishDate(Date.from(v)));
        context.setRootDirectory(this.project.getBasedir());
        if (!locale.equals(SiteTool.DEFAULT_LOCALE)) {
            context.addSiteDirectory(new SiteRenderingContext.SiteDirectory(new File(this.siteDirectory, locale.toString()), true));
            context.addSiteDirectory(new SiteRenderingContext.SiteDirectory(new File(this.generatedSiteDirectory, locale.toString()), false));
        } else {
            context.addSiteDirectory(new SiteRenderingContext.SiteDirectory(this.siteDirectory, true));
            context.addSiteDirectory(new SiteRenderingContext.SiteDirectory(this.generatedSiteDirectory, false));
        }
        if (this.moduleExcludes != null) {
            context.setModuleExcludes(this.moduleExcludes);
        }
        if (this.saveProcessedContent) {
            File processedDir = new File(this.generatedSiteDirectory, "processed");
            if (!locale.equals(SiteTool.DEFAULT_LOCALE)) {
                context.setProcessedContentOutput(new File(processedDir, locale.toString()));
            } else {
                context.setProcessedContentOutput(processedDir);
            }
        }
        return context;
    }

    protected Map<String, MavenReport> locateReports(List<MavenReportExecution> reports, Map<String, DocumentRenderer> documents, Locale locale) {
        LinkedHashMap<String, MavenReport> reportsByOutputName = new LinkedHashMap<String, MavenReport>();
        for (MavenReportExecution mavenReportExecution : reports) {
            MavenReport report = mavenReportExecution.getMavenReport();
            String outputName = report.getOutputName();
            String filename = outputName + ".html";
            reportsByOutputName.put(outputName, report);
            if (documents.containsKey(filename)) {
                String reportMojoInfo = mavenReportExecution.getGoal() == null ? "" : " (" + mavenReportExecution.getPlugin().getArtifactId() + ':' + mavenReportExecution.getPlugin().getVersion() + ':' + mavenReportExecution.getGoal() + ')';
                this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report" + reportMojoInfo + ", file \"" + filename + "\" already exists."));
                continue;
            }
            File localizedSiteDirectory = !locale.equals(SiteTool.DEFAULT_LOCALE) ? new File(this.siteDirectory, locale.toString()) : this.siteDirectory;
            String generator = mavenReportExecution.getGoal() == null ? null : mavenReportExecution.getPlugin().getId() + ':' + mavenReportExecution.getGoal();
            DocumentRenderingContext docRenderingContext = new DocumentRenderingContext(localizedSiteDirectory, outputName, generator);
            ReportDocumentRenderer docRenderer = new ReportDocumentRenderer(mavenReportExecution, docRenderingContext, this.getLog());
            documents.put(filename, docRenderer);
        }
        return reportsByOutputName;
    }

    protected Map<String, List<MavenReport>> categoriseReports(Collection<MavenReport> reports) {
        LinkedHashMap<String, List<MavenReport>> categories = new LinkedHashMap<String, List<MavenReport>>();
        for (MavenReport report : reports) {
            ArrayList<MavenReport> categoryReports = (ArrayList<MavenReport>)categories.get(report.getCategoryName());
            if (categoryReports == null) {
                categoryReports = new ArrayList<MavenReport>();
                categories.put(report.getCategoryName(), categoryReports);
            }
            categoryReports.add(report);
        }
        return categories;
    }

    protected Map<String, DocumentRenderer> locateDocuments(SiteRenderingContext context, List<MavenReportExecution> reports, Locale locale) throws IOException, RendererException {
        String filename;
        CategorySummaryDocumentRenderer docRenderer;
        String desc2;
        String desc1;
        String title;
        DocumentRenderingContext docRenderingContext;
        MojoExecution subMojoExecution;
        List<MavenReport> categoryReports;
        Map documents = this.siteRenderer.locateDocumentFiles(context);
        Map<String, MavenReport> reportsByOutputName = this.locateReports(reports, documents, locale);
        Map<String, List<MavenReport>> categories = this.categoriseReports(reportsByOutputName.values());
        this.siteTool.populateReportsMenu(context.getSiteModel(), locale, categories);
        this.populateReportItems(context.getSiteModel(), locale, reportsByOutputName);
        File localizedSiteDirectory = !locale.equals(SiteTool.DEFAULT_LOCALE) ? new File(this.siteDirectory, locale.toString()) : this.siteDirectory;
        if (categories.containsKey("Project Info") && this.generateProjectInfo) {
            categoryReports = categories.get("Project Info");
            subMojoExecution = new MojoExecution(this.mojoExecution.getPlugin(), "project-info", this.mojoExecution.getExecutionId());
            docRenderer = new CategorySummaryDocumentRenderer(subMojoExecution, docRenderingContext = new DocumentRenderingContext(localizedSiteDirectory, subMojoExecution.getGoal(), subMojoExecution.getPlugin().getId() + ':' + subMojoExecution.getGoal()), title = this.i18n.getString("site-plugin", locale, "report.information.title"), desc1 = this.i18n.getString("site-plugin", locale, "report.information.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.information.description2"), this.i18n, categoryReports, this.getLog());
            filename = docRenderer.getOutputName();
            if (!documents.containsKey(filename)) {
                documents.put(filename, docRenderer);
            } else {
                this.getLog().info((CharSequence)("Skipped \"" + title + "\" report; file \"" + filename + "\" already exists."));
            }
        }
        if (categories.containsKey("Project Reports")) {
            categoryReports = categories.get("Project Reports");
            subMojoExecution = new MojoExecution(this.mojoExecution.getPlugin(), "project-reports", this.mojoExecution.getExecutionId());
            docRenderer = new CategorySummaryDocumentRenderer(subMojoExecution, docRenderingContext = new DocumentRenderingContext(localizedSiteDirectory, subMojoExecution.getGoal(), subMojoExecution.getPlugin().getId() + ':' + subMojoExecution.getGoal()), title = this.i18n.getString("site-plugin", locale, "report.project.title"), desc1 = this.i18n.getString("site-plugin", locale, "report.project.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.project.description2"), this.i18n, categoryReports, this.getLog());
            filename = docRenderer.getOutputName();
            if (!documents.containsKey(filename)) {
                documents.put(filename, docRenderer);
            } else {
                this.getLog().info((CharSequence)("Skipped \"" + title + "\" report; file \"" + filename + "\" already exists."));
            }
        }
        if (this.generateSitemap) {
            String title2;
            DocumentRenderingContext docRenderingContext2;
            MojoExecution subMojoExecution2 = new MojoExecution(this.mojoExecution.getPlugin(), "sitemap", this.mojoExecution.getExecutionId());
            SitemapDocumentRenderer docRenderer2 = new SitemapDocumentRenderer(subMojoExecution2, docRenderingContext2 = new DocumentRenderingContext(localizedSiteDirectory, subMojoExecution2.getGoal(), subMojoExecution2.getPlugin().getId() + ':' + subMojoExecution2.getGoal()), title2 = this.i18n.getString("site-plugin", locale, "site.sitemap.title"), context.getSiteModel(), this.i18n, this.getLog());
            String filename2 = docRenderer2.getOutputName();
            if (!documents.containsKey(filename2)) {
                documents.put(filename2, docRenderer2);
            } else {
                this.getLog().info((CharSequence)("Skipped \"" + title2 + "\" report; file \"" + filename2 + "\" already exists."));
            }
        }
        return documents;
    }

    protected void populateReportItems(SiteModel siteModel, Locale locale, Map<String, MavenReport> reportsByOutputName) {
        for (Menu menu : siteModel.getMenus()) {
            this.populateItemRefs(menu.getItems(), locale, reportsByOutputName);
        }
    }

    private void populateItemRefs(List<MenuItem> items, Locale locale, Map<String, MavenReport> reportsByOutputName) {
        Iterator<MenuItem> i = items.iterator();
        while (i.hasNext()) {
            MenuItem item = i.next();
            if (item.getRef() != null) {
                MavenReport report = reportsByOutputName.get(item.getRef());
                if (report != null) {
                    if (item.getName() == null) {
                        item.setName(report.getName(locale));
                    }
                    if (item.getHref() == null || item.getHref().length() == 0) {
                        item.setHref(report.getOutputName() + ".html");
                    }
                } else {
                    this.getLog().warn((CharSequence)("Unrecognised reference: '" + item.getRef() + "'"));
                    i.remove();
                }
            }
            this.populateItemRefs(item.getItems(), locale, reportsByOutputName);
        }
    }
}

