/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.repository.BundleUtils;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class BundlePackMojo
extends AbstractMojo {
    public static final String POM = "pom.xml";
    protected JarArchiver jarArchiver;
    protected ArtifactResolver artifactResolver;
    protected ArtifactFactory artifactFactory;
    protected ArtifactRepository localRepository;
    protected InputHandler inputHandler;
    protected String basedir;
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String scmUrl;
    protected String scmConnection;
    protected Settings settings;
    private boolean disableMaterialization;

    public void execute() throws MojoExecutionException {
        this.readArtifactDataFromUser();
        Artifact artifact = this.artifactFactory.createProjectArtifact(this.groupId, this.artifactId, this.version);
        try {
            this.artifactResolver.resolve(artifact, Collections.EMPTY_LIST, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact " + artifact.getId(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Artifact " + artifact.getId() + " not found in local repository", (Exception)((Object)e));
        }
        File pom = artifact.getFile();
        File dir = pom.getParentFile();
        Model model = this.readPom(pom);
        boolean rewrite = false;
        try {
            List licenses;
            if (model.getPackaging() == null) {
                model.setPackaging("jar");
                rewrite = true;
            }
            if (model.getName() == null) {
                this.getLog().info((CharSequence)("Project name is missing, please type the project name [" + this.artifactId + "]:"));
                model.setName(this.inputHandler.readLine());
                if (model.getName() == null) {
                    model.setName(this.artifactId);
                }
                rewrite = true;
            }
            if (model.getDescription() == null) {
                this.getLog().info((CharSequence)"Project description is missing, please type the project description:");
                model.setDescription(this.inputHandler.readLine());
                rewrite = true;
            }
            if (model.getUrl() == null) {
                this.getLog().info((CharSequence)"Project URL is missing, please type the project URL:");
                model.setUrl(this.inputHandler.readLine());
                rewrite = true;
            }
            if ((licenses = model.getLicenses()).isEmpty()) {
                License license = new License();
                this.getLog().info((CharSequence)"License name is missing, please type the license name:");
                license.setName(this.inputHandler.readLine());
                this.getLog().info((CharSequence)"License URL is missing, please type the license URL:");
                license.setUrl(this.inputHandler.readLine());
                licenses.add(license);
                rewrite = true;
            }
            if (this.disableMaterialization) {
                this.getLog().warn((CharSequence)"Validations to confirm support for project materialization have been DISABLED.\n\nYour project may not provide the POM elements necessary to allow users to retrieve sources on-demand,\nor to easily checkout your project in an IDE. THIS CAN SERIOUSLY INCONVENIENCE YOUR USERS.\n\nContinue? [y/N]");
                try {
                    if ('y' != this.inputHandler.readLine().toLowerCase().charAt(0)) {
                        this.disableMaterialization = false;
                    }
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)("Error reading confirmation: " + e.getMessage()), (Throwable)e);
                }
            }
            if (!this.disableMaterialization) {
                Scm scm = model.getScm();
                if (scm == null) {
                    scm = new Scm();
                    model.setScm(scm);
                }
                if (scm.getUrl() == null) {
                    if (this.scmUrl != null) {
                        scm.setUrl(this.scmUrl);
                    } else {
                        this.getLog().info((CharSequence)"SCM view URL is missing, please type the URL for the viewable SCM interface:");
                        scm.setUrl(this.inputHandler.readLine());
                        rewrite = true;
                    }
                }
                if (scm.getConnection() == null) {
                    if (this.scmConnection != null) {
                        scm.setConnection(this.scmConnection);
                    } else {
                        this.getLog().info((CharSequence)"SCM read-only connection URL is missing, please type the read-only SCM URL:");
                        scm.setConnection(this.inputHandler.readLine());
                        rewrite = true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            if (rewrite) {
                new MavenXpp3Writer().write((Writer)WriterFactory.newXmlWriter((File)pom), model);
            }
            String finalName = null;
            if (model.getBuild() != null) {
                finalName = model.getBuild().getFinalName();
            }
            if (finalName == null) {
                finalName = model.getArtifactId() + "-" + model.getVersion();
            }
            boolean batchMode = this.settings == null ? false : !this.settings.isInteractiveMode();
            List<File> files = BundleUtils.selectProjectFiles(dir, this.inputHandler, finalName, pom, this.getLog(), batchMode);
            File bundle = new File(this.basedir, finalName + "-bundle.jar");
            this.jarArchiver.addFile(pom, POM);
            boolean artifactChecks = !"pom".equals(model.getPackaging());
            boolean sourcesFound = false;
            boolean javadocsFound = false;
            for (File f : files) {
                if (artifactChecks && f.getName().endsWith(finalName + "-sources.jar")) {
                    sourcesFound = true;
                } else if (artifactChecks && f.getName().equals(finalName + "-javadoc.jar")) {
                    javadocsFound = true;
                }
                this.jarArchiver.addFile(f, f.getName());
            }
            if (artifactChecks && !sourcesFound) {
                this.getLog().warn((CharSequence)"Sources not included in upload bundle.");
            }
            if (artifactChecks && !javadocsFound) {
                this.getLog().warn((CharSequence)"Javadoc not included in upload bundle.");
            }
            this.jarArchiver.setDestFile(bundle);
            this.jarArchiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void readArtifactDataFromUser() throws MojoExecutionException {
        try {
            if (this.groupId == null) {
                this.getLog().info((CharSequence)"groupId? ");
                this.groupId = this.inputHandler.readLine();
            }
            if (this.artifactId == null) {
                this.getLog().info((CharSequence)"artifactId? ");
                this.artifactId = this.inputHandler.readLine();
            }
            if (this.version == null) {
                this.getLog().info((CharSequence)"version? ");
                this.version = this.inputHandler.readLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private Model readPom(File pom) throws MojoExecutionException {
        Model model;
        try {
            model = new MavenXpp3Reader().read((Reader)ReaderFactory.newXmlReader((File)pom));
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Unable to parse POM at " + pom.getAbsolutePath() + ": " + e.getMessage(), (Exception)((Object)e));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to read POM at " + pom.getAbsolutePath() + ": " + e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read POM at " + pom.getAbsolutePath() + ": " + e.getMessage(), (Exception)e);
        }
        return model;
    }
}

