/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.StringUtils;

public class RepositoryUtils {
    private final Log log;
    private final WagonManager wagonManager;
    private final Settings settings;
    private final MavenProjectBuilder mavenProjectBuilder;
    private final ArtifactFactory factory;
    private final List remoteRepositories;
    private final List pluginRepositories;
    private final ArtifactResolver resolver;
    private final ArtifactRepository localRepository;

    public RepositoryUtils(Log log, WagonManager wagonManager, Settings settings, MavenProjectBuilder mavenProjectBuilder, ArtifactFactory factory, ArtifactResolver resolver, List remoteRepositories, List pluginRepositories, ArtifactRepository localRepository, RepositoryMetadataManager repositoryMetadataManager) {
        this.log = log;
        this.wagonManager = wagonManager;
        this.settings = settings;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.factory = factory;
        this.resolver = resolver;
        this.remoteRepositories = remoteRepositories;
        this.pluginRepositories = pluginRepositories;
        this.localRepository = localRepository;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public List getRemoteArtifactRepositories() {
        return this.remoteRepositories;
    }

    public List getPluginArtifactRepositories() {
        return this.pluginRepositories;
    }

    public void resolve(Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList repos = new ArrayList();
        repos.addAll(this.pluginRepositories);
        repos.addAll(this.remoteRepositories);
        this.resolver.resolve(artifact, repos, this.localRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dependencyExistsInRepo(ArtifactRepository repo, Artifact artifact) {
        Wagon wagon;
        if (repo.isBlacklisted()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("The repo '" + repo.getId() + "' is black listed - Ignored it"));
            }
            return false;
        }
        repo = this.wagonManager.getMirrorRepository(repo);
        String id = repo.getId();
        Repository repository = new Repository(id, repo.getUrl());
        try {
            wagon = this.wagonManager.getWagon(repository);
        }
        catch (UnsupportedProtocolException e) {
            this.log.error((CharSequence)("Unsupported protocol: '" + repo.getProtocol() + "'"), (Throwable)e);
            return false;
        }
        catch (WagonConfigurationException e) {
            this.log.error((CharSequence)("Unsupported protocol: '" + repo.getProtocol() + "'"), (Throwable)e);
            return false;
        }
        wagon.setTimeout(1000);
        if (this.log.isDebugEnabled()) {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
        }
        try {
            AuthenticationInfo auth = this.wagonManager.getAuthenticationInfo(repo.getId());
            ProxyInfo proxyInfo = this.getProxyInfo();
            if (proxyInfo != null) {
                wagon.connect(repository, auth, proxyInfo);
            } else {
                wagon.connect(repository, auth);
            }
            boolean bl = wagon.resourceExists(StringUtils.replace((String)this.getDependencyUrlFromRepository(artifact, repo), (String)repo.getUrl(), (String)""));
            return bl;
        }
        catch (ConnectionException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((CharSequence)("Unable to connect to: " + repo.getUrl()), (Throwable)e);
            } else {
                this.log.error((CharSequence)("Unable to connect to: " + repo.getUrl()));
            }
            boolean bl = false;
            return bl;
        }
        catch (AuthenticationException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((CharSequence)("Unable to connect to: " + repo.getUrl()), (Throwable)e);
            } else {
                this.log.error((CharSequence)("Unable to connect to: " + repo.getUrl()));
            }
            boolean bl = false;
            return bl;
        }
        catch (TransferFailedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((CharSequence)("Unable to determine if resource " + artifact + " exists in " + repo.getUrl()), (Throwable)e);
            } else {
                this.log.error((CharSequence)("Unable to determine if resource " + artifact + " exists in " + repo.getUrl()));
            }
            boolean bl = false;
            return bl;
        }
        catch (AuthorizationException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((CharSequence)("Unable to connect to: " + repo.getUrl()), (Throwable)e);
            } else {
                this.log.error((CharSequence)("Unable to connect to: " + repo.getUrl()));
            }
            boolean bl = false;
            return bl;
        }
        catch (AbstractMethodError e) {
            this.log.error((CharSequence)("Wagon " + wagon.getClass().getName() + " does not support the resourceExists method"));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
                }
                this.log.error((CharSequence)"Error disconnecting wagon - ignored");
            }
        }
    }

    public MavenProject getMavenProjectFromRepository(Artifact artifact) throws ProjectBuildingException {
        Artifact projectArtifact = artifact;
        boolean allowStubModel = false;
        if (!"pom".equals(artifact.getType())) {
            projectArtifact = this.factory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            allowStubModel = true;
        }
        return this.mavenProjectBuilder.buildFromRepository(projectArtifact, this.remoteRepositories, this.localRepository, allowStubModel);
    }

    public String getDependencyUrlFromRepository(Artifact artifact, ArtifactRepository repo) {
        if (repo.isBlacklisted()) {
            return null;
        }
        Artifact copyArtifact = ArtifactUtils.copyArtifact((Artifact)artifact);
        if (artifact.isSnapshot() && repo.getSnapshots().isEnabled() && artifact.getBaseVersion().equals(artifact.getVersion())) {
            if (artifact.getMetadataList() == null || artifact.getMetadataList().isEmpty()) {
                try {
                    this.resolve(artifact);
                }
                catch (ArtifactResolutionException e) {
                    this.log.error((CharSequence)("Artifact: " + artifact.getId() + " could not be resolved."));
                }
                catch (ArtifactNotFoundException e) {
                    this.log.error((CharSequence)("Artifact: " + artifact.getId() + " was not found."));
                }
            }
            Iterator it = artifact.getMetadataList().iterator();
            while (it.hasNext()) {
                SnapshotArtifactRepositoryMetadata snapshotMetadata;
                Metadata metadata;
                ArtifactMetadata m = (ArtifactMetadata)it.next();
                if (!(m instanceof SnapshotArtifactRepositoryMetadata) || (metadata = (snapshotMetadata = (SnapshotArtifactRepositoryMetadata)m).getMetadata()).getVersioning() == null || metadata.getVersioning().getSnapshot() == null || metadata.getVersioning().getSnapshot().isLocalCopy() || metadata.getVersioning().getSnapshot().getTimestamp() == null) continue;
                String version = StringUtils.replace((String)copyArtifact.getVersion(), (String)"SNAPSHOT", (String)metadata.getVersioning().getSnapshot().getTimestamp()) + "-" + metadata.getVersioning().getSnapshot().getBuildNumber();
                copyArtifact.setVersion(version);
            }
        }
        return repo.getUrl() + "/" + repo.pathOf(copyArtifact);
    }

    private ProxyInfo getProxyInfo() {
        ProxyInfo proxyInfo = null;
        if (this.settings != null && this.settings.getActiveProxy() != null) {
            Proxy settingsProxy = this.settings.getActiveProxy();
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(settingsProxy.getHost());
            proxyInfo.setType(settingsProxy.getProtocol());
            proxyInfo.setPort(settingsProxy.getPort());
            proxyInfo.setNonProxyHosts(settingsProxy.getNonProxyHosts());
            proxyInfo.setUserName(settingsProxy.getUsername());
            proxyInfo.setPassword(settingsProxy.getPassword());
        }
        return proxyInfo;
    }
}

