/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;

public class DependencyConvergenceReport
extends AbstractProjectInfoReport {
    private static final int PERCENTAGE = 100;
    private List reactorProjects;

    public String getOutputName() {
        return "dependency-convergence";
    }

    protected String getI18Nsection() {
        return "dependency-convergence";
    }

    public boolean canGenerateReport() {
        return this.reactorProjects.size() > 1;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text(this.getI18nString(locale, "title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.getI18nString(locale, "title"));
        sink.sectionTitle1_();
        Map dependencyMap = this.getDependencyMap();
        this.generateLegend(locale, sink);
        sink.lineBreak();
        this.generateStats(locale, sink, dependencyMap);
        sink.section1_();
        this.generateConvergence(locale, sink, dependencyMap);
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void generateConvergence(Locale locale, Sink sink, Map dependencyMap) {
        sink.section2();
        sink.sectionTitle2();
        sink.text(this.getI18nString(locale, "convergence.caption"));
        sink.sectionTitle2_();
        Iterator it = dependencyMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            List depList = (List)dependencyMap.get(key);
            sink.section3();
            sink.sectionTitle3();
            sink.text(key);
            sink.sectionTitle3_();
            this.generateDependencyDetails(sink, depList);
            sink.section3_();
        }
        sink.section2_();
    }

    private void generateDependencyDetails(Sink sink, List depList) {
        sink.table();
        Map artifactMap = this.getSortedUniqueArtifactMap(depList);
        sink.tableRow();
        sink.tableCell();
        if (artifactMap.size() > 1) {
            this.iconError(sink);
        } else {
            this.iconSuccess(sink);
        }
        sink.tableCell_();
        sink.tableCell();
        sink.table();
        Iterator it = artifactMap.keySet().iterator();
        while (it.hasNext()) {
            String version = (String)it.next();
            sink.tableRow();
            sink.tableCell((SinkEventAttributes)new SinkEventAttributeSet(new String[]{"width", "25%"}));
            sink.text(version);
            sink.tableCell_();
            sink.tableCell();
            this.generateVersionDetails(sink, artifactMap, version);
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.tableCell_();
        sink.tableRow_();
        sink.table_();
    }

    private void generateVersionDetails(Sink sink, Map artifactMap, String version) {
        sink.numberedList(1);
        List depList = (List)artifactMap.get(version);
        Collections.sort(depList, new ReverseDependencyLinkComparator());
        Iterator it = depList.iterator();
        while (it.hasNext()) {
            ReverseDependencyLink rdl = (ReverseDependencyLink)it.next();
            sink.numberedListItem();
            if (StringUtils.isNotEmpty((String)rdl.project.getUrl())) {
                sink.link(rdl.project.getUrl());
            }
            sink.text(rdl.project.getGroupId() + ":" + rdl.project.getArtifactId());
            if (StringUtils.isNotEmpty((String)rdl.project.getUrl())) {
                sink.link_();
            }
            sink.numberedListItem_();
        }
        sink.numberedList_();
    }

    private Map getSortedUniqueArtifactMap(List depList) {
        TreeMap<String, ArrayList<ReverseDependencyLink>> uniqueArtifactMap = new TreeMap<String, ArrayList<ReverseDependencyLink>>();
        Iterator it = depList.iterator();
        while (it.hasNext()) {
            ReverseDependencyLink rdl = (ReverseDependencyLink)it.next();
            String key = rdl.getDependency().getVersion();
            ArrayList<ReverseDependencyLink> projectList = (ArrayList<ReverseDependencyLink>)uniqueArtifactMap.get(key);
            if (projectList == null) {
                projectList = new ArrayList<ReverseDependencyLink>();
            }
            projectList.add(rdl);
            uniqueArtifactMap.put(key, projectList);
        }
        return uniqueArtifactMap;
    }

    private void generateLegend(Locale locale, Sink sink) {
        sink.table();
        sink.tableCaption();
        sink.bold();
        sink.text(this.getI18nString(locale, "legend"));
        sink.bold_();
        sink.tableCaption_();
        sink.tableRow();
        sink.tableCell();
        this.iconSuccess(sink);
        sink.tableCell_();
        sink.tableCell();
        sink.text(this.getI18nString(locale, "legend.shared"));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        this.iconError(sink);
        sink.tableCell_();
        sink.tableCell();
        sink.text(this.getI18nString(locale, "legend.different"));
        sink.tableCell_();
        sink.tableRow_();
        sink.table_();
    }

    private void generateStats(Locale locale, Sink sink, Map dependencyMap) {
        int depCount = dependencyMap.size();
        int artifactCount = 0;
        int snapshotCount = 0;
        Iterator it = dependencyMap.values().iterator();
        while (it.hasNext()) {
            List depList = (List)it.next();
            Map artifactMap = this.getSortedUniqueArtifactMap(depList);
            snapshotCount += this.countSnapshots(artifactMap);
            artifactCount += artifactMap.size();
        }
        int convergence = (int)((double)depCount / (double)artifactCount * 100.0);
        sink.table();
        sink.tableCaption();
        sink.bold();
        sink.text(this.getI18nString(locale, "stats.caption"));
        sink.bold_();
        sink.tableCaption_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.subprojects"));
        sink.tableHeaderCell_();
        sink.tableCell();
        sink.text(String.valueOf(this.reactorProjects.size()));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.dependencies"));
        sink.tableHeaderCell_();
        sink.tableCell();
        sink.text(String.valueOf(depCount));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.artifacts"));
        sink.tableHeaderCell_();
        sink.tableCell();
        sink.text(String.valueOf(artifactCount));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.snapshots"));
        sink.tableHeaderCell_();
        sink.tableCell();
        sink.text(String.valueOf(snapshotCount));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.convergence"));
        sink.tableHeaderCell_();
        sink.tableCell();
        if (convergence < 100) {
            this.iconError(sink);
        } else {
            this.iconSuccess(sink);
        }
        sink.nonBreakingSpace();
        sink.bold();
        sink.text(String.valueOf(convergence) + "%");
        sink.bold_();
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.readyrelease"));
        sink.tableHeaderCell_();
        sink.tableCell();
        if (convergence >= 100 && snapshotCount <= 0) {
            this.iconSuccess(sink);
            sink.nonBreakingSpace();
            sink.bold();
            sink.text(this.getI18nString(locale, "stats.readyrelease.success"));
            sink.bold_();
        } else {
            this.iconError(sink);
            sink.nonBreakingSpace();
            sink.bold();
            sink.text(this.getI18nString(locale, "stats.readyrelease.error"));
            sink.bold_();
            if (convergence < 100) {
                sink.lineBreak();
                sink.text(this.getI18nString(locale, "stats.readyrelease.error.convergence"));
            }
            if (snapshotCount > 0) {
                sink.lineBreak();
                sink.text(this.getI18nString(locale, "stats.readyrelease.error.snapshots"));
            }
        }
        sink.tableCell_();
        sink.tableRow_();
        sink.table_();
    }

    private int countSnapshots(Map artifactMap) {
        int count = 0;
        Iterator it = artifactMap.keySet().iterator();
        while (it.hasNext()) {
            ReverseDependencyLink rdl;
            String version = (String)it.next();
            boolean isReactorProject = false;
            Iterator iterator = ((List)artifactMap.get(version)).iterator();
            if (iterator.hasNext() && this.isReactorProject((rdl = (ReverseDependencyLink)iterator.next()).getDependency())) {
                isReactorProject = true;
            }
            if (!version.endsWith("-SNAPSHOT") || isReactorProject) continue;
            ++count;
        }
        return count;
    }

    private boolean isReactorProject(Dependency dependency) {
        Iterator iterator = this.reactorProjects.iterator();
        while (iterator.hasNext()) {
            MavenProject mavenProject = (MavenProject)iterator.next();
            if (!mavenProject.getGroupId().equals(dependency.getGroupId()) || !mavenProject.getArtifactId().equals(dependency.getArtifactId())) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(dependency + " is a reactor project"));
            }
            return true;
        }
        return false;
    }

    private void iconSuccess(Sink sink) {
        sink.figure();
        sink.figureCaption();
        sink.text("success");
        sink.figureCaption_();
        sink.figureGraphics("images/icon_success_sml.gif");
        sink.figure_();
    }

    private void iconError(Sink sink) {
        sink.figure();
        sink.figureCaption();
        sink.text("error");
        sink.figureCaption_();
        sink.figureGraphics("images/icon_error_sml.gif");
        sink.figure_();
    }

    private Map getDependencyMap() {
        Iterator it = this.reactorProjects.iterator();
        TreeMap<String, ArrayList<ReverseDependencyLink>> dependencyMap = new TreeMap<String, ArrayList<ReverseDependencyLink>>();
        while (it.hasNext()) {
            MavenProject reactorProject = (MavenProject)it.next();
            Iterator itdep = reactorProject.getDependencies().iterator();
            while (itdep.hasNext()) {
                Dependency dep = (Dependency)itdep.next();
                String key = dep.getGroupId() + ":" + dep.getArtifactId();
                ArrayList<ReverseDependencyLink> depList = (ArrayList<ReverseDependencyLink>)dependencyMap.get(key);
                if (depList == null) {
                    depList = new ArrayList<ReverseDependencyLink>();
                }
                depList.add(new ReverseDependencyLink(dep, reactorProject));
                dependencyMap.put(key, depList);
            }
        }
        return dependencyMap;
    }

    static class ReverseDependencyLinkComparator
    implements Comparator {
        ReverseDependencyLinkComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ReverseDependencyLink && o2 instanceof ReverseDependencyLink) {
                ReverseDependencyLink p1 = (ReverseDependencyLink)o1;
                ReverseDependencyLink p2 = (ReverseDependencyLink)o2;
                return p1.getProject().getId().compareTo(p2.getProject().getId());
            }
            return 0;
        }
    }

    private static class ReverseDependencyLink {
        private Dependency dependency;
        protected MavenProject project;

        ReverseDependencyLink(Dependency dependency, MavenProject project) {
            this.dependency = dependency;
            this.project = project;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public MavenProject getProject() {
            return this.project;
        }

        public String toString() {
            return this.project.getId();
        }
    }
}

