/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.AbstractGeneratorMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginDescriptorHelper;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.generator.PluginDescriptorFilesGenerator;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.util.ReaderFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="descriptor", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class DescriptorGeneratorMojo
extends AbstractGeneratorMojo {
    private static final String VALUE_AUTO = "auto";
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/maven", readonly=true)
    private File outputDirectory;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="false")
    private boolean skipDescriptor;
    @Parameter
    private Set<String> extractors;
    @Parameter(property="maven.plugin.skipErrorNoDescriptorsFound", defaultValue="false")
    private boolean skipErrorNoDescriptorsFound;
    @Parameter(defaultValue="true", property="maven.plugin.checkExpectedProvidedScope")
    private boolean checkExpectedProvidedScope = true;
    @Parameter
    private List<String> expectedProvidedScopeGroupIds = Collections.singletonList("org.apache.maven");
    @Parameter
    private List<String> expectedProvidedScopeExclusions = Arrays.asList("org.apache.maven:maven-archiver", "org.apache.maven:maven-jxr", "org.apache.maven:plexus-utils");
    @Parameter
    private List<String> mojoDependencies = null;
    @Parameter(property="externalJavadocBaseUrls", alias="links")
    protected List<URI> externalJavadocBaseUrls;
    @Parameter(property="internalJavadocBaseUrl")
    protected URI internalJavadocBaseUrl;
    @Parameter(property="internalJavadocVersion", defaultValue="${java.version}")
    protected String internalJavadocVersion;
    @Parameter(defaultValue="auto")
    String requiredJavaVersion;
    @Parameter(defaultValue="auto")
    String requiredMavenVersion;
    private final MavenSession mavenSession;
    private final MojoScanner mojoScanner;
    protected final BuildContext buildContext;

    @Inject
    public DescriptorGeneratorMojo(MavenProject project, MavenSession mavenSession, MojoScanner mojoScanner, BuildContext buildContext) {
        super(project);
        this.mavenSession = mavenSession;
        this.mojoScanner = mojoScanner;
        this.buildContext = buildContext;
    }

    @Override
    public void generate() throws MojoExecutionException {
        Set<Artifact> wrongScopedArtifacts;
        if (!"maven-plugin".equalsIgnoreCase(this.project.getArtifactId()) && this.project.getArtifactId().toLowerCase().startsWith("maven-") && this.project.getArtifactId().toLowerCase().endsWith("-plugin") && !"org.apache.maven.plugins".equals(this.project.getGroupId())) {
            this.getLog().warn((CharSequence)(LS + LS + "Artifact Ids of the format maven-___-plugin are reserved for" + LS + "plugins in the Group Id org.apache.maven.plugins" + LS + "Please change your artifactId to the format ___-maven-plugin" + LS + "In the future this error will break the build." + LS + LS));
        }
        if (this.skipDescriptor) {
            this.getLog().warn((CharSequence)"Execution skipped");
            return;
        }
        if (this.checkExpectedProvidedScope && !(wrongScopedArtifacts = this.dependenciesNotInProvidedScope()).isEmpty()) {
            StringBuilder message = new StringBuilder(LS + LS + "Some dependencies of Maven Plugins are expected to be in provided scope." + LS + "Please make sure that dependencies listed below declared in POM" + LS + "have set '<scope>provided</scope>' as well." + LS + LS + "The following dependencies are in wrong scope:" + LS);
            for (Artifact artifact : wrongScopedArtifacts) {
                message.append(" * ").append(artifact).append(LS);
            }
            message.append(LS).append(LS);
            this.getLog().warn((CharSequence)message.toString());
        }
        this.mojoScanner.setActiveExtractors(this.extractors);
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(this.goalPrefix);
        pluginDescriptor.setName(this.project.getName());
        pluginDescriptor.setDescription(this.project.getDescription());
        if (this.encoding == null || this.encoding.length() < 1) {
            this.getLog().warn((CharSequence)("Using platform encoding (" + ReaderFactory.FILE_ENCODING + " actually) to read mojo source files, i.e. build is platform dependent!"));
        } else {
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' encoding to read mojo source files."));
        }
        if (this.internalJavadocBaseUrl != null && !this.internalJavadocBaseUrl.getPath().endsWith("/")) {
            throw new MojoExecutionException("Given parameter 'internalJavadocBaseUrl' must end with a slash but is '" + this.internalJavadocBaseUrl + "'");
        }
        try {
            List deps = GeneratorUtils.toComponentDependencies((Collection)this.project.getArtifacts());
            pluginDescriptor.setDependencies(deps);
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            request.setEncoding(this.encoding);
            request.setSkipErrorNoDescriptorsFound(this.skipErrorNoDescriptorsFound);
            request.setDependencies(this.filterMojoDependencies());
            request.setRepoSession(this.mavenSession.getRepositorySession());
            request.setInternalJavadocBaseUrl(this.internalJavadocBaseUrl);
            request.setInternalJavadocVersion(this.internalJavadocVersion);
            request.setExternalJavadocBaseUrls(this.externalJavadocBaseUrls);
            request.setSettings(this.mavenSession.getSettings());
            this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
            request.setPluginDescriptor(this.extendPluginDescriptor((PluginToolsRequest)request));
            this.outputDirectory.mkdirs();
            PluginDescriptorFilesGenerator pluginDescriptorGenerator = new PluginDescriptorFilesGenerator();
            pluginDescriptorGenerator.execute(this.outputDirectory, (PluginToolsRequest)request);
            this.buildContext.refresh(this.outputDirectory);
        }
        catch (GeneratorException e) {
            throw new MojoExecutionException("Error writing plugin descriptor", (Exception)((Object)e));
        }
        catch (InvalidPluginDescriptorException | ExtractionException e) {
            throw new MojoExecutionException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)e);
        }
        catch (LinkageError e) {
            throw new MojoExecutionException("The API of the mojo scanner is not compatible with this plugin version. Please check the plugin dependencies configured in the POM and ensure the versions match.", (Throwable)e);
        }
    }

    private PluginDescriptor extendPluginDescriptor(PluginToolsRequest request) {
        PluginDescriptor pluginDescriptor = request.getPluginDescriptor();
        pluginDescriptor.setRequiredMavenVersion(this.getRequiredMavenVersion(request));
        return PluginDescriptorHelper.setRequiredJavaVersion((PluginDescriptor)pluginDescriptor, (String)this.getRequiredJavaVersion(request));
    }

    private String getRequiredMavenVersion(PluginToolsRequest request) {
        String requiredMavenVersion;
        if (!VALUE_AUTO.equals(this.requiredMavenVersion)) {
            return this.requiredMavenVersion;
        }
        this.getLog().debug((CharSequence)"Trying to derive Maven version automatically from project prerequisites...");
        String string = requiredMavenVersion = this.project.getPrerequisites() != null ? this.project.getPrerequisites().getMaven() : null;
        if (requiredMavenVersion == null) {
            this.getLog().debug((CharSequence)"Trying to derive Maven version automatically from referenced Maven Plugin API artifact version...");
            requiredMavenVersion = request.getUsedMavenApiVersion();
        }
        if (requiredMavenVersion == null) {
            this.getLog().warn((CharSequence)"Cannot determine the required Maven version automatically, it is recommended to configure some explicit value manually.");
        }
        return requiredMavenVersion;
    }

    private String getRequiredJavaVersion(PluginToolsRequest request) {
        if (!VALUE_AUTO.equals(this.requiredJavaVersion)) {
            return this.requiredJavaVersion;
        }
        String minRequiredJavaVersion = request.getRequiredJavaVersion();
        if (minRequiredJavaVersion == null) {
            this.getLog().warn((CharSequence)"Cannot determine the minimally required Java version automatically, it is recommended to configure some explicit value manually.");
            return null;
        }
        return minRequiredJavaVersion;
    }

    private Set<Artifact> dependenciesNotInProvidedScope() {
        LinkedHashSet<Artifact> wrongScopedDependencies = new LinkedHashSet<Artifact>();
        for (Artifact dependency : this.project.getArtifacts()) {
            String ga = dependency.getGroupId() + ":" + dependency.getArtifactId();
            if (!this.expectedProvidedScopeGroupIds.contains(dependency.getGroupId()) || this.expectedProvidedScopeExclusions.contains(ga) || "provided".equals(dependency.getScope())) continue;
            wrongScopedDependencies.add(dependency);
        }
        return wrongScopedDependencies;
    }

    private Set<Artifact> filterMojoDependencies() {
        LinkedHashSet<Artifact> filteredArtifacts;
        if (this.mojoDependencies == null) {
            filteredArtifacts = new LinkedHashSet<Artifact>(this.project.getArtifacts());
        } else if (this.mojoDependencies.isEmpty()) {
            filteredArtifacts = null;
        } else {
            filteredArtifacts = new LinkedHashSet();
            IncludesArtifactFilter filter = new IncludesArtifactFilter(this.mojoDependencies);
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!filter.include(artifact)) continue;
                filteredArtifacts.add(artifact);
            }
        }
        return filteredArtifacts;
    }
}

