/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.javadoc.JavadocJar;
import org.apache.maven.plugin.javadoc.JavadocUtil;
import org.apache.maven.plugin.javadoc.resolver.SourceResolverConfig;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="test-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class TestJavadocJar
extends JavadocJar {
    @Parameter(defaultValue="${project.build.directory}/testapidocs", required=true)
    private File outputDirectory;
    @Parameter(property="testDoctitle", alias="doctitle", defaultValue="${project.name} ${project.version} Test API")
    private String testDoctitle;
    @Parameter(property="testOverview", alias="overview", defaultValue="${basedir}/src/test/javadoc/overview.html")
    private File testOverview;
    @Parameter(property="testWindowtitle", alias="windowtitle", defaultValue="${project.name} ${project.version} Test API")
    private String testWindowtitle;
    @Parameter(alias="javadocDirectory", defaultValue="${basedir}/src/test/javadoc")
    private File testJavadocDirectory;

    @Override
    protected String getClassifier() {
        return "test-javadoc";
    }

    @Override
    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    @Override
    protected File getJavadocDirectory() {
        return this.testJavadocDirectory;
    }

    @Override
    protected String getDoctitle() {
        return this.testDoctitle;
    }

    @Override
    protected File getOverview() {
        return this.testOverview;
    }

    @Override
    protected String getWindowtitle() {
        return this.testWindowtitle;
    }

    @Override
    protected List<String> getProjectBuildOutputDirs(MavenProject p) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)p.getBuild().getOutputDirectory())) {
            dirs.add(p.getBuild().getOutputDirectory());
        }
        if (StringUtils.isNotEmpty((String)p.getBuild().getTestOutputDirectory())) {
            dirs.add(p.getBuild().getTestOutputDirectory());
        }
        return dirs;
    }

    @Override
    protected List<String> getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.emptyList();
        }
        return p.getTestCompileSourceRoots();
    }

    @Override
    protected List<String> getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.emptyList();
        }
        return p.getExecutionProject().getTestCompileSourceRoots();
    }

    @Override
    protected List<Artifact> getProjectArtifacts(MavenProject p) {
        return p.getTestArtifacts();
    }

    @Override
    protected List<Artifact> getCompileArtifacts(ArtifactResolutionResult result) {
        return JavadocUtil.getCompileArtifacts(result.getArtifacts(), true);
    }

    @Override
    protected SourceResolverConfig configureDependencySourceResolution(SourceResolverConfig config) {
        return super.configureDependencySourceResolution(config).withoutCompileSources().withTestSources();
    }
}

