/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.4 on 2010-11-23 11:53:17,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * Represents a set of reports and configuration to be used to
 * generate them.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class ReportSet
    implements java.io.Serializable, java.lang.Cloneable, org.apache.maven.model.InputLocationTracker
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The unique id for this report set, to be used during POM
     * inheritance and profile injection
     *             for merging of report sets.
     *           
     */
    private String id = "default";

    /**
     * Configuration of the report to be used when generating this
     * set.
     */
    private Object configuration;

    /**
     * Whether any configuration should be propagated to child POMs.
     */
    private String inherited;

    /**
     * Field reports.
     */
    private java.util.List<String> reports;

    /**
     * Field locations.
     */
    private java.util.Map<Object, InputLocation> locations;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addReport.
     * 
     * @param string
     */
    public void addReport( String string )
    {
        getReports().add( string );
    } //-- void addReport( String )

    /**
     * Method clone.
     * 
     * @return ReportSet
     */
    public ReportSet clone()
    {
        try
        {
            ReportSet copy = (ReportSet) super.clone();

            if ( this.configuration != null )
            {
                copy.configuration = new org.codehaus.plexus.util.xml.Xpp3Dom( (org.codehaus.plexus.util.xml.Xpp3Dom) this.configuration );
            }

            if ( this.reports != null )
            {
                copy.reports = new java.util.ArrayList<String>();
                copy.reports.addAll( this.reports );
            }

            if ( copy.locations != null )
            {
                copy.locations = new java.util.LinkedHashMap( copy.locations );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- ReportSet clone()

    /**
     * Get configuration of the report to be used when generating
     * this set.
     * 
     * @return Object
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration()

    /**
     * Get the unique id for this report set, to be used during POM
     * inheritance and profile injection
     *             for merging of report sets.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * Get whether any configuration should be propagated to child
     * POMs.
     * 
     * @return String
     */
    public String getInherited()
    {
        return this.inherited;
    } //-- String getInherited()

    /**
     * 
     * 
     * @param key
     * @return InputLocation
     */
    public InputLocation getLocation( Object key )
    {
        return ( locations != null ) ? locations.get( key ) : null;
    } //-- InputLocation getLocation( Object )

    /**
     * Method getReports.
     * 
     * @return List
     */
    public java.util.List<String> getReports()
    {
        if ( this.reports == null )
        {
            this.reports = new java.util.ArrayList<String>();
        }

        return this.reports;
    } //-- java.util.List<String> getReports()

    /**
     * Method removeReport.
     * 
     * @param string
     */
    public void removeReport( String string )
    {
        getReports().remove( string );
    } //-- void removeReport( String )

    /**
     * Set configuration of the report to be used when generating
     * this set.
     * 
     * @param configuration
     */
    public void setConfiguration( Object configuration )
    {
        this.configuration = configuration;
    } //-- void setConfiguration( Object )

    /**
     * Set the unique id for this report set, to be used during POM
     * inheritance and profile injection
     *             for merging of report sets.
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set whether any configuration should be propagated to child
     * POMs.
     * 
     * @param inherited
     */
    public void setInherited( String inherited )
    {
        this.inherited = inherited;
    } //-- void setInherited( String )

    /**
     * 
     * 
     * @param key
     * @param location
     */
    public void setLocation( Object key, InputLocation location )
    {
        if ( location != null )
        {
            if ( this.locations == null )
            {
                this.locations = new java.util.LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put( key, location );
        }
    } //-- void setLocation( Object, InputLocation )

    /**
     * Set the list of reports from this plugin which should be
     * generated from this set.
     * 
     * @param reports
     */
    public void setReports( java.util.List<String> reports )
    {
        this.reports = reports;
    } //-- void setReports( java.util.List )

    
            
    private boolean inheritanceApplied = true;

    public void unsetInheritanceApplied()
    {
        this.inheritanceApplied = false;
    }

    public boolean isInheritanceApplied()
    {
        return inheritanceApplied;
    }

    @Override
    public String toString()
    {
        return getId();
    }
            
          
}
