/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         The <code>&lt;execution&gt;</code> element contains
 * informations required for the
 *         execution of a plugin.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class PluginExecution extends ConfigurationContainer 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The identifier of this execution for labelling the goals
     * during the build,
     *             and for matching executions to merge during
     * inheritance.
     */
    private String id = "default";

    /**
     * The build lifecycle phase to bind the goals in this
     * execution to. If omitted,
     *             the goals will be bound to the default phase
     * specified in their metadata. 
     */
    private String phase;

    /**
     * Field goals.
     */
    private java.util.List goals;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addGoal.
     * 
     * @param string
     */
    public void addGoal( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "PluginExecution.addGoals(string) parameter must be instanceof " + String.class.getName() );
        }
        getGoals().add( string );
    } //-- void addGoal( String ) 

    /**
     * Method getGoals.
     * 
     * @return java.util.List
     */
    public java.util.List getGoals()
    {
        if ( this.goals == null )
        {
            this.goals = new java.util.ArrayList();
        }
    
        return this.goals;
    } //-- java.util.List getGoals() 

    /**
     * Get the identifier of this execution for labelling the goals
     * during the build,
     *             and for matching executions to merge during
     * inheritance.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get the build lifecycle phase to bind the goals in this
     * execution to. If omitted,
     *             the goals will be bound to the default phase
     * specified in their metadata. 
     * 
     * @return String
     */
    public String getPhase()
    {
        return this.phase;
    } //-- String getPhase() 

    /**
     * Method removeGoal.
     * 
     * @param string
     */
    public void removeGoal( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "PluginExecution.removeGoals(string) parameter must be instanceof " + String.class.getName() );
        }
        getGoals().remove( string );
    } //-- void removeGoal( String ) 

    /**
     * Set the goals to execute with the given configuration.
     * 
     * @param goals
     */
    public void setGoals( java.util.List goals )
    {
        this.goals = goals;
    } //-- void setGoals( java.util.List ) 

    /**
     * Set the identifier of this execution for labelling the goals
     * during the build,
     *             and for matching executions to merge during
     * inheritance.
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String ) 

    /**
     * Set the build lifecycle phase to bind the goals in this
     * execution to. If omitted,
     *             the goals will be bound to the default phase
     * specified in their metadata. 
     * 
     * @param phase
     */
    public void setPhase( String phase )
    {
        this.phase = phase;
    } //-- void setPhase( String ) 


            
    public static final String DEFAULT_EXECUTION_ID = "default";
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
