/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class LastTwoLinesBufferingWriter
extends Writer {
    private final Writer out;
    private String previousLine;
    private StringBuilder currentLine;
    private final String lineSeparator;

    public LastTwoLinesBufferingWriter(Writer out) {
        this(out, System.getProperty("line.separator"));
    }

    LastTwoLinesBufferingWriter(Writer out, String lineSeparator) {
        this.out = out;
        this.previousLine = "";
        this.currentLine = new StringBuilder();
        this.lineSeparator = lineSeparator;
    }

    public boolean isWriterAtStartOfNewLine() {
        return this.currentLine.length() == 0;
    }

    public boolean isWriterAfterBlankLine() {
        return StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.currentLine}) && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.previousLine});
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int index;
        int offsetWrittenInLineBuffer = off;
        for (index = 0; index < len; ++index) {
            if (cbuf[off + index] != '\r' && cbuf[off + index] != '\n') continue;
            int lenToWrite = index + 1 - (offsetWrittenInLineBuffer - off);
            this.flushLine(cbuf, offsetWrittenInLineBuffer, lenToWrite);
            offsetWrittenInLineBuffer += lenToWrite;
        }
        this.flushLine(cbuf, offsetWrittenInLineBuffer, index - (offsetWrittenInLineBuffer - off));
        this.out.write(cbuf, off, len);
    }

    private void flushLine(char[] cbuf, int off, int len) {
        this.currentLine.append(cbuf, off, len);
        if (this.currentLine.toString().endsWith(this.lineSeparator)) {
            this.previousLine = this.currentLine.toString();
            this.currentLine.setLength(0);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

