/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.ldap.LDAPCache;
import org.apache.karaf.jaas.modules.ldap.LDAPOptions;
import org.apache.karaf.jaas.modules.ldap.ManagedSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPLoginModule
extends AbstractKarafLoginModule {
    private static Logger logger = LoggerFactory.getLogger(LDAPLoginModule.class);

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
    }

    @Override
    public boolean login() throws LoginException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            boolean bl = this.doLogin();
            return bl;
        }
        finally {
            ManagedSSLSocketFactory.setSocketFactory(null);
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doLogin() throws LoginException {
        String[] userDnAndNamespace;
        String authentication;
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioException) {
            throw new LoginException(ioException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage() + " not available to obtain information from user.");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        LDAPOptions options = new LDAPOptions(this.options);
        if (options.isUsernameTrim() && this.user != null) {
            this.user = this.user.trim();
        }
        if ("none".equals(authentication = options.getAuthentication()) && (this.user != null || tmpPassword != null)) {
            logger.debug("Changing from authentication = none to simple since user or password was specified.");
            authentication = "simple";
            HashMap<String, String> opts = new HashMap<String, String>(this.options);
            opts.put("authentication", authentication);
            options = new LDAPOptions(opts);
        }
        boolean allowEmptyPasswords = options.getAllowEmptyPasswords();
        if (!("none".equals(authentication) || allowEmptyPasswords || tmpPassword != null && tmpPassword.length != 0)) {
            throw new LoginException("Empty passwords not allowed");
        }
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        String password = new String(tmpPassword);
        this.principals = new HashSet();
        LDAPCache cache = LDAPCache.getCache(options);
        try {
            logger.debug("Get the user DN.");
            userDnAndNamespace = cache.getUserDnAndNamespace(this.user);
            if (userDnAndNamespace == null) {
                return false;
            }
        }
        catch (Exception e) {
            logger.warn("Can't connect to the LDAP server: {}", (Object)e.getMessage(), (Object)e);
            throw new LoginException("Can't connect to the LDAP server: " + e.getMessage());
        }
        Context context = null;
        try {
            logger.debug("Bind user (authentication).");
            Hashtable<String, Object> env = options.getEnv();
            env.put("java.naming.security.authentication", authentication);
            logger.debug("Set the security principal for " + userDnAndNamespace[0] + "," + options.getUserBaseDn());
            env.put("java.naming.security.principal", userDnAndNamespace[0] + "," + options.getUserBaseDn());
            env.put("java.naming.security.credentials", password);
            logger.debug("Binding the user.");
            context = new InitialDirContext(env);
            logger.debug("User " + this.user + " successfully bound.");
            context.close();
        }
        catch (Exception e) {
            logger.warn("User " + this.user + " authentication failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception exception) {}
            }
        }
        this.principals.add(new UserPrincipal(this.user));
        try {
            String[] roles;
            for (String role : roles = cache.getUserRoles(this.user, userDnAndNamespace[0], userDnAndNamespace[1])) {
                this.principals.add(new RolePrincipal(role));
            }
        }
        catch (Exception e) {
            throw new LoginException("Can't get user " + this.user + " roles: " + e.getMessage());
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }
}

