/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.generated;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataRecord;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataUpdateRecord;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemotePartitionDeleteMetadataRecord;

public enum MetadataRecordType {
    REMOTE_LOG_SEGMENT_METADATA_RECORD("RemoteLogSegmentMetadataRecord", 0, 0, 0),
    REMOTE_LOG_SEGMENT_METADATA_UPDATE_RECORD("RemoteLogSegmentMetadataUpdateRecord", 1, 0, 0),
    REMOTE_PARTITION_DELETE_METADATA_RECORD("RemotePartitionDeleteMetadataRecord", 2, 0, 0);

    private final String name;
    private final short id;
    private final short lowestSupportedVersion;
    private final short highestSupportedVersion;

    private MetadataRecordType(String name, short id, short lowestSupportedVersion, short highestSupportedVersion) {
        this.name = name;
        this.id = id;
        this.lowestSupportedVersion = lowestSupportedVersion;
        this.highestSupportedVersion = highestSupportedVersion;
    }

    public static MetadataRecordType fromId(short id) {
        switch (id) {
            case 0: {
                return REMOTE_LOG_SEGMENT_METADATA_RECORD;
            }
            case 1: {
                return REMOTE_LOG_SEGMENT_METADATA_UPDATE_RECORD;
            }
            case 2: {
                return REMOTE_PARTITION_DELETE_METADATA_RECORD;
            }
        }
        throw new UnsupportedVersionException("Unknown metadata id " + id);
    }

    public ApiMessage newMetadataRecord() {
        switch (this.id) {
            case 0: {
                return new RemoteLogSegmentMetadataRecord();
            }
            case 1: {
                return new RemoteLogSegmentMetadataUpdateRecord();
            }
            case 2: {
                return new RemotePartitionDeleteMetadataRecord();
            }
        }
        throw new UnsupportedVersionException("Unknown metadata id " + this.id);
    }

    public short id() {
        return this.id;
    }

    public short lowestSupportedVersion() {
        return this.lowestSupportedVersion;
    }

    public short highestSupportedVersion() {
        return this.highestSupportedVersion;
    }

    public String toString() {
        return this.name();
    }
}

