/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;

public interface ReplicatedLog
extends AutoCloseable {
    public LogAppendInfo appendAsLeader(Records var1, int var2);

    public LogAppendInfo appendAsFollower(Records var1);

    public LogFetchInfo read(long var1, Isolation var3);

    public int lastFetchedEpoch();

    default public ValidOffsetAndEpoch validateOffsetAndEpoch(long offset, int epoch) {
        if (this.startOffset() == 0L && offset == 0L) {
            return ValidOffsetAndEpoch.valid(new OffsetAndEpoch(0L, 0));
        }
        Optional<OffsetAndEpoch> earliestSnapshotId = this.earliestSnapshotId();
        if (earliestSnapshotId.isPresent() && (offset < this.startOffset() || offset == this.startOffset() && epoch != earliestSnapshotId.get().epoch() || epoch < earliestSnapshotId.get().epoch())) {
            OffsetAndEpoch latestSnapshotId = this.latestSnapshotId().orElseThrow(() -> new IllegalStateException(String.format("Log start offset (%s) is greater than zero but latest snapshot was not found", this.startOffset())));
            return ValidOffsetAndEpoch.snapshot(latestSnapshotId);
        }
        OffsetAndEpoch endOffsetAndEpoch = this.endOffsetForEpoch(epoch);
        if (endOffsetAndEpoch.epoch() != epoch || endOffsetAndEpoch.offset() < offset) {
            return ValidOffsetAndEpoch.diverging(endOffsetAndEpoch);
        }
        return ValidOffsetAndEpoch.valid(new OffsetAndEpoch(offset, epoch));
    }

    public OffsetAndEpoch endOffsetForEpoch(int var1);

    public LogOffsetMetadata endOffset();

    public LogOffsetMetadata highWatermark();

    public long startOffset();

    public void initializeLeaderEpoch(int var1);

    public void truncateTo(long var1);

    public boolean truncateToLatestSnapshot();

    public void updateHighWatermark(LogOffsetMetadata var1);

    public boolean deleteBeforeSnapshot(OffsetAndEpoch var1);

    public void flush(boolean var1);

    public boolean maybeClean();

    public long lastFlushedOffset();

    public TopicPartition topicPartition();

    public Uuid topicId();

    default public long truncateToEndOffset(OffsetAndEpoch endOffset) {
        OffsetAndEpoch localEndOffset;
        int leaderEpoch = endOffset.epoch();
        long truncationOffset = leaderEpoch == 0 ? Math.min(endOffset.offset(), this.endOffset().offset) : ((localEndOffset = this.endOffsetForEpoch(leaderEpoch)).epoch() == leaderEpoch ? Math.min(localEndOffset.offset(), endOffset.offset()) : localEndOffset.offset());
        this.truncateTo(truncationOffset);
        return truncationOffset;
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch var1);

    public Optional<RawSnapshotWriter> storeSnapshot(OffsetAndEpoch var1);

    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch var1);

    public Optional<RawSnapshotReader> latestSnapshot();

    public Optional<OffsetAndEpoch> latestSnapshotId();

    public Optional<OffsetAndEpoch> earliestSnapshotId();

    public void onSnapshotFrozen(OffsetAndEpoch var1);

    @Override
    default public void close() {
    }
}

