/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.Java;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaTest {
    private String javaVendor;

    @BeforeEach
    public void before() {
        this.javaVendor = System.getProperty("java.vendor");
    }

    @AfterEach
    public void after() {
        System.setProperty("java.vendor", this.javaVendor);
    }

    @Test
    public void testIsIBMJdk() {
        System.setProperty("java.vendor", "Oracle Corporation");
        Assertions.assertFalse((boolean)Java.isIbmJdk());
        System.setProperty("java.vendor", "IBM Corporation");
        Assertions.assertTrue((boolean)Java.isIbmJdk());
    }

    @Test
    public void testLoadKerberosLoginModule() throws ClassNotFoundException {
        String clazz = Java.isIbmJdk() ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        Class.forName(clazz);
    }

    @Test
    public void testJavaVersion() {
        Java.Version v = Java.parseVersion((String)"9");
        Assertions.assertEquals((int)9, (int)v.majorVersion);
        Assertions.assertEquals((int)0, (int)v.minorVersion);
        Assertions.assertTrue((boolean)v.isJava9Compatible());
        v = Java.parseVersion((String)"9.0.1");
        Assertions.assertEquals((int)9, (int)v.majorVersion);
        Assertions.assertEquals((int)0, (int)v.minorVersion);
        Assertions.assertTrue((boolean)v.isJava9Compatible());
        v = Java.parseVersion((String)"9.0.0.15");
        Assertions.assertEquals((int)9, (int)v.majorVersion);
        Assertions.assertEquals((int)0, (int)v.minorVersion);
        Assertions.assertTrue((boolean)v.isJava9Compatible());
        v = Java.parseVersion((String)"9.1");
        Assertions.assertEquals((int)9, (int)v.majorVersion);
        Assertions.assertEquals((int)1, (int)v.minorVersion);
        Assertions.assertTrue((boolean)v.isJava9Compatible());
        v = Java.parseVersion((String)"1.8.0_152");
        Assertions.assertEquals((int)1, (int)v.majorVersion);
        Assertions.assertEquals((int)8, (int)v.minorVersion);
        Assertions.assertFalse((boolean)v.isJava9Compatible());
        v = Java.parseVersion((String)"1.7.0_80");
        Assertions.assertEquals((int)1, (int)v.majorVersion);
        Assertions.assertEquals((int)7, (int)v.minorVersion);
        Assertions.assertFalse((boolean)v.isJava9Compatible());
    }
}

