/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kafka.common.message.EnvelopeResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EnvelopeResponseTest {
    EnvelopeResponseTest() {
    }

    @Test
    public void testToSend() {
        Iterator iterator = ApiKeys.ENVELOPE.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ByteBuffer responseData = ByteBuffer.wrap("foobar".getBytes());
            EnvelopeResponse response = new EnvelopeResponse(responseData, Errors.NONE);
            short headerVersion = ApiKeys.ENVELOPE.responseHeaderVersion(version);
            ResponseHeader header = new ResponseHeader(15, headerVersion);
            Send send = response.toSend(header, version);
            ByteBuffer buffer = TestUtils.toBuffer(send);
            Assertions.assertEquals((long)(send.size() - 4L), (long)buffer.getInt());
            Assertions.assertEquals((Object)header, (Object)ResponseHeader.parse((ByteBuffer)buffer, (short)headerVersion));
            EnvelopeResponseData parsedResponseData = new EnvelopeResponseData();
            parsedResponseData.read((Readable)new ByteBufferAccessor(buffer), version);
            Assertions.assertEquals((Object)response.data(), (Object)parsedResponseData);
        }
    }
}

