/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;

public class NodeTransformExpr
extends ExprTransformCopy {
    private final NodeTransform transform;

    public NodeTransformExpr(NodeTransform transform) {
        this.transform = transform;
    }

    @Override
    public Expr transform(NodeValue nv) {
        return this.transform(nv.asNode());
    }

    @Override
    public Expr transform(ExprVar exprVar) {
        return this.transform(exprVar.getAsNode());
    }

    private Expr transform(Node input) {
        Node n = (Node)this.transform.apply(input);
        if (n == null) {
            throw new InternalErrorException("NodeTransform creates a null");
        }
        if (!Var.isVar(n)) {
            return NodeValue.makeNode(n);
        }
        String name = Var.alloc(n).getVarName();
        return new ExprVar(n.getName());
    }
}

