/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.List;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprUndefFunction;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.function.js.EnvJavaScript;
import org.apache.jena.sparql.function.js.FunctionJavaScript;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;

public class E_Function
extends ExprFunctionN {
    private static final String name = "function";
    public static boolean WarnOnUnknownFunction = true;
    private String functionIRI;
    private String javaScriptFunction = null;
    private Function function = null;
    private boolean functionBound = false;

    public E_Function(String functionIRI, ExprList args) {
        super(name, args);
        this.functionIRI = functionIRI;
        if (functionIRI.startsWith("http://jena.apache.org/ARQ/jsFunction#")) {
            this.javaScriptFunction = functionIRI.substring("http://jena.apache.org/ARQ/jsFunction#".length());
        }
    }

    @Override
    public String getFunctionIRI() {
        return this.functionIRI;
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        if (this.javaScriptFunction != null) {
            EnvJavaScript jsEnv = EnvJavaScript.get();
            if (jsEnv == null) {
                ARQ.getExecLogger().warn("JavaScript function found '" + this.javaScriptFunction + "' but no JavaScript library installed");
                throw new ExprUndefFunction("No JavaScript function library", this.javaScriptFunction);
            }
            this.function = new FunctionJavaScript(this.javaScriptFunction, jsEnv);
            try {
                return this.function.exec(binding, this.args, this.getFunctionIRI(), env);
            }
            catch (ExprUndefFunction ex) {
                if (WarnOnUnknownFunction) {
                    ARQ.getExecLogger().warn("JavaScript function not found: " + ex.getFunctionName());
                }
                throw ex;
            }
        }
        if (!this.functionBound) {
            this.buildFunction(env.getContext());
        }
        if (this.function == null) {
            throw new ExprEvalException("URI <" + this.getFunctionIRI() + "> not bound");
        }
        NodeValue r = this.function.exec(binding, this.args, this.getFunctionIRI(), env);
        return r;
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        throw new ARQInternalErrorException();
    }

    public void buildFunction(Context cxt) {
        block3: {
            if (this.javaScriptFunction != null) {
                return;
            }
            try {
                this.bindFunction(cxt);
            }
            catch (ExprUndefFunction ex) {
                if (!WarnOnUnknownFunction) break block3;
                ARQ.getExecLogger().warn("URI <" + this.functionIRI + "> has no registered function factory");
            }
        }
    }

    private FunctionFactory functionFactory(Context cxt) {
        FunctionRegistry registry = this.chooseRegistry(cxt);
        FunctionFactory ff = registry.get(this.functionIRI);
        return ff;
    }

    private void bindFunction(Context cxt) {
        if (this.functionBound) {
            return;
        }
        FunctionFactory ff = this.functionFactory(cxt);
        if (ff == null) {
            this.functionBound = true;
            throw new ExprUndefFunction("URI <" + this.functionIRI + "> not found as a function", this.functionIRI);
        }
        this.function = ff.create(this.functionIRI);
        this.function.build(this.functionIRI, this.args);
        this.functionBound = true;
    }

    private FunctionRegistry chooseRegistry(Context context) {
        FunctionRegistry registry = FunctionRegistry.get(context);
        if (registry == null) {
            registry = FunctionRegistry.get();
        }
        return registry;
    }

    @Override
    public String getFunctionPrintName(SerializationContext cxt) {
        return FmtUtils.stringForURI(this.functionIRI, cxt);
    }

    @Override
    public String getFunctionName(SerializationContext cxt) {
        return FmtUtils.stringForURI(this.functionIRI, cxt);
    }

    @Override
    public Expr copy(ExprList newArgs) {
        return new E_Function(this.getFunctionIRI(), newArgs);
    }
}

