/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.util.VarUtils;

public class VarFinder {
    VarUsageVisitor varUsageVisitor;

    public static VarFinder process(Op op) {
        return new VarFinder(op);
    }

    public static Set<Var> optDefined(Op op) {
        return VarUsageVisitor.apply((Op)op).optDefines;
    }

    public static Set<Var> fixed(Op op) {
        return VarUsageVisitor.apply((Op)op).defines;
    }

    public static Set<Var> filter(Op op) {
        return VarUsageVisitor.apply((Op)op).filterMentions;
    }

    public static Set<Var> assignMention(Op op) {
        return VarUsageVisitor.apply((Op)op).assignMentions;
    }

    private VarFinder(Op op) {
        this.varUsageVisitor = VarUsageVisitor.apply(op);
    }

    public Set<Var> getOpt() {
        return this.varUsageVisitor.optDefines;
    }

    public Set<Var> getFilter() {
        return this.varUsageVisitor.filterMentions;
    }

    public Set<Var> getFilterOnly() {
        return this.varUsageVisitor.filterMentionsOnly;
    }

    public Set<Var> getAssign() {
        return this.varUsageVisitor.assignMentions;
    }

    public Set<Var> getFixed() {
        return this.varUsageVisitor.defines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fixed:").append(this.getFixed());
        sb.append(", Filter:").append(this.getFilter());
        sb.append(", Filter2:").append(this.getFilterOnly());
        sb.append(", Opt:").append(this.getOpt());
        sb.append(", Assign:").append(this.getAssign());
        return sb.toString();
    }

    public void print(PrintStream out) {
        out.printf("  Filter:       %s\n", this.getFilter());
        out.printf("  Filter only:  %s\n", this.getFilterOnly());
        out.printf("  Fixed :       %s\n", this.getFixed());
        out.printf("  Opt:          %s\n", this.getOpt());
        out.printf("  Assign:       %s\n", this.getAssign());
    }

    private static class VarUsageVisitor
    implements OpVisitor {
        Set<Var> defines = null;
        Set<Var> optDefines = null;
        Set<Var> filterMentions = null;
        Set<Var> filterMentionsOnly = null;
        Set<Var> assignMentions = null;

        static VarUsageVisitor apply(Op op) {
            VarUsageVisitor v = new VarUsageVisitor();
            op.visit(v);
            return v;
        }

        VarUsageVisitor() {
            this.defines = new HashSet<Var>();
            this.optDefines = new HashSet<Var>();
            this.filterMentions = new HashSet<Var>();
            this.filterMentionsOnly = new HashSet<Var>();
            this.assignMentions = new HashSet<Var>();
        }

        VarUsageVisitor(Set<Var> _defines, Set<Var> _optDefines, Set<Var> _filterMentions, Set<Var> _filterMentions2, Set<Var> _assignMentions) {
            this.defines = _defines;
            this.optDefines = _optDefines;
            this.filterMentions = _filterMentions;
            this.filterMentionsOnly = _filterMentions2;
            this.assignMentions = _assignMentions;
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            VarUtils.addVars(this.defines, quadPattern.getGraphNode(), quadPattern.getBasicPattern());
        }

        @Override
        public void visit(OpBGP opBGP) {
            BasicPattern triples = opBGP.getPattern();
            VarUtils.addVars(this.defines, triples);
        }

        @Override
        public void visit(OpQuadBlock quadBlock) {
            VarUtils.addVars(this.defines, quadBlock.getPattern());
        }

        @Override
        public void visit(OpTriple opTriple) {
            VarUtils.addVarsFromTriple(this.defines, opTriple.getTriple());
        }

        @Override
        public void visit(OpQuad opQuad) {
            VarUtils.addVarsFromQuad(this.defines, opQuad.getQuad());
        }

        @Override
        public void visit(OpPath opPath) {
            VarUtils.addVarsFromTriplePath(this.defines, opPath.getTriplePath());
        }

        @Override
        public void visit(OpExt opExt) {
            opExt.effectiveOp().visit(this);
        }

        @Override
        public void visit(OpJoin opJoin) {
            this.mergeVars(opJoin.getLeft());
            this.mergeVars(opJoin.getRight());
        }

        @Override
        public void visit(OpSequence opSequence) {
            for (Op op : opSequence.getElements()) {
                this.mergeVars(op);
            }
        }

        private void mergeVars(Op op) {
            VarUsageVisitor usage = VarUsageVisitor.apply(op);
            this.defines.addAll(usage.defines);
            this.optDefines.addAll(usage.optDefines);
            this.filterMentions.addAll(usage.filterMentions);
            this.filterMentionsOnly.addAll(usage.filterMentionsOnly);
            this.assignMentions.addAll(usage.assignMentions);
        }

        @Override
        public void visit(OpLeftJoin opLeftJoin) {
            this.leftJoin(opLeftJoin.getLeft(), opLeftJoin.getRight(), opLeftJoin.getExprs());
        }

        @Override
        public void visit(OpMinus opMinus) {
            this.mergeMinusDiff(opMinus.getLeft(), opMinus.getRight());
        }

        @Override
        public void visit(OpDiff opDiff) {
            this.mergeMinusDiff(opDiff.getLeft(), opDiff.getRight());
        }

        private void mergeMinusDiff(Op left, Op right) {
            this.mergeVars(left);
            VarUsageVisitor usage = VarUsageVisitor.apply(right);
            VarUsageVisitor.combinefilterMentions(this, usage.filterMentionsOnly);
            this.filterMentions.addAll(usage.defines);
            this.filterMentions.addAll(usage.optDefines);
            this.filterMentions.addAll(usage.filterMentions);
            this.filterMentions.addAll(usage.assignMentions);
        }

        private static void combinefilterMentions(VarUsageVisitor usage, Set<Var> mentions) {
            for (Var v : mentions) {
                if (usage.defines.contains((Object)v)) continue;
                usage.filterMentionsOnly.add(v);
            }
        }

        @Override
        public void visit(OpConditional opLeftJoin) {
            this.leftJoin(opLeftJoin.getLeft(), opLeftJoin.getRight(), null);
        }

        private void leftJoin(Op left, Op right, ExprList exprs) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(left);
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(right);
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.filterMentionsOnly.addAll(leftUsage.filterMentionsOnly);
            this.assignMentions.addAll(leftUsage.assignMentions);
            this.optDefines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
            this.filterMentionsOnly.addAll(rightUsage.filterMentionsOnly);
            this.assignMentions.addAll(rightUsage.assignMentions);
            this.optDefines.removeAll(leftUsage.defines);
            if (exprs != null) {
                this.processExpr(exprs, rightUsage.defines);
                ExprVars.varsMentioned(this.filterMentions, exprs);
            }
        }

        private void processExpr(ExprList exprs, Set<Var> additionalDefines) {
            Set<Var> vars = ExprVars.getVarsMentioned(exprs);
            this.filterMentions.addAll(vars);
            for (Var v : vars) {
                if (this.defines.contains((Object)v) || additionalDefines != null && additionalDefines.contains((Object)v)) continue;
                this.filterMentionsOnly.add(v);
            }
        }

        @Override
        public void visit(OpUnion opUnion) {
            VarUsageVisitor usage1 = VarUsageVisitor.apply(opUnion.getLeft());
            VarUsageVisitor usage2 = VarUsageVisitor.apply(opUnion.getRight());
            Set fixed = SetUtils.intersection(usage1.defines, usage2.defines);
            this.defines.addAll(fixed);
            Set notFixed = SetUtils.symmetricDifference(usage1.defines, usage2.defines);
            this.optDefines.addAll(notFixed);
            this.optDefines.addAll(usage1.optDefines);
            this.optDefines.addAll(usage2.optDefines);
            this.filterMentions.addAll(usage1.filterMentions);
            this.filterMentions.addAll(usage2.filterMentions);
            this.filterMentionsOnly.addAll(usage1.filterMentionsOnly);
            this.filterMentionsOnly.addAll(usage2.filterMentionsOnly);
            this.assignMentions.addAll(usage1.assignMentions);
            this.assignMentions.addAll(usage2.assignMentions);
        }

        @Override
        public void visit(OpDisjunction opDisjunction) {
            opDisjunction.getElements().forEach(op -> this.mergeVars((Op)op));
        }

        @Override
        public void visit(OpGraph opGraph) {
            VarUtils.addVar(this.defines, opGraph.getNode());
            opGraph.getSubOp().visit(this);
        }

        @Override
        public void visit(OpFilter opFilter) {
            opFilter.getSubOp().visit(this);
            this.processExpr(opFilter.getExprs(), null);
        }

        @Override
        public void visit(OpAssign opAssign) {
            opAssign.getSubOp().visit(this);
            this.processAssignVarExprList(opAssign.getVarExprList());
        }

        @Override
        public void visit(OpExtend opExtend) {
            opExtend.getSubOp().visit(this);
            this.processAssignVarExprList(opExtend.getVarExprList());
        }

        private void processAssignVarExprList(VarExprList varExprList) {
            varExprList.forEachVarExpr((v, e2) -> {
                this.defines.add((Var)((Object)v));
                if (e2 != null) {
                    ExprVars.nonOpVarsMentioned(this.assignMentions, e2);
                }
            });
        }

        @Override
        public void visit(OpProject opProject) {
            List<Var> vars = opProject.getVars();
            VarUsageVisitor subUsage = VarUsageVisitor.apply(opProject.getSubOp());
            subUsage.defines.retainAll(vars);
            subUsage.optDefines.retainAll(vars);
            subUsage.filterMentions.retainAll(vars);
            subUsage.filterMentionsOnly.retainAll(vars);
            subUsage.assignMentions.retainAll(vars);
            this.defines.addAll(subUsage.defines);
            this.optDefines.addAll(subUsage.optDefines);
            this.filterMentions.addAll(subUsage.filterMentions);
            this.filterMentionsOnly.addAll(subUsage.filterMentionsOnly);
            this.assignMentions.addAll(subUsage.assignMentions);
        }

        @Override
        public void visit(OpTable opTable) {
            this.defines.addAll(opTable.getTable().getVars());
        }

        @Override
        public void visit(OpNull opNull) {
        }

        @Override
        public void visit(OpPropFunc opPropFunc) {
            VarUtils.addVars(this.defines, opPropFunc.getSubjectArgs());
            VarUtils.addVars(this.defines, opPropFunc.getObjectArgs());
            this.mergeVars(opPropFunc.getSubOp());
            this.optDefines.removeAll(this.defines);
        }

        @Override
        public void visit(OpReduced opReduced) {
            this.mergeVars(opReduced.getSubOp());
        }

        @Override
        public void visit(OpDistinct opDistinct) {
            this.mergeVars(opDistinct.getSubOp());
        }

        @Override
        public void visit(OpSlice opSlice) {
            this.mergeVars(opSlice.getSubOp());
        }

        @Override
        public void visit(OpLabel opLabel) {
            this.mergeVars(opLabel.getSubOp());
        }

        @Override
        public void visit(OpList opList) {
            this.mergeVars(opList.getSubOp());
        }

        @Override
        public void visit(OpService opService) {
            this.mergeVars(opService.getSubOp());
        }

        @Override
        public void visit(OpTopN opTop) {
            this.mergeVars(opTop.getSubOp());
        }

        @Override
        public void visit(OpOrder opOrder) {
            this.mergeVars(opOrder.getSubOp());
            opOrder.getConditions().forEach(sc -> sc.getExpression());
        }

        @Override
        public void visit(OpGroup opGroup) {
            VarExprList varExprs = opGroup.getGroupVars();
            varExprs.forEachVar(v -> VarUtils.addVar(this.defines, (Node)v));
        }

        @Override
        public void visit(OpDatasetNames dsNames) {
            VarUtils.addVar(this.defines, dsNames.getGraphNode());
        }

        @Override
        public void visit(OpProcedure opProc) {
            for (Expr expr : opProc.getArgs()) {
                Set<Var> vars = expr.getVarsMentioned();
                this.defines.addAll(vars);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Fixed:").append(this.defines);
            sb.append(", Filter:").append(this.filterMentions);
            sb.append(", Filter2:").append(this.filterMentionsOnly);
            sb.append(", Opt:").append(this.optDefines);
            sb.append(", Assign:").append(this.assignMentions);
            return sb.toString();
        }
    }
}

