/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.sparql.algebra.table.TableBase;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;

public class TableN
extends TableBase {
    protected List<Binding> rows = new ArrayList<Binding>();
    protected List<Var> vars = new ArrayList<Var>();

    public TableN() {
    }

    public TableN(List<Var> vars) {
        if (vars != null) {
            this.vars = vars;
        }
    }

    public TableN(QueryIterator qIter) {
        this.materialize(qIter);
    }

    protected TableN(List<Var> variables, List<Binding> rows) {
        this.vars = variables;
        this.rows = rows;
    }

    private void materialize(QueryIterator qIter) {
        while (qIter.hasNext()) {
            Binding binding = qIter.nextBinding();
            this.addBinding(binding);
        }
        qIter.close();
    }

    @Override
    public void addBinding(Binding binding) {
        Iterator<Var> names = binding.vars();
        while (names.hasNext()) {
            Var v = names.next();
            if (this.vars.contains((Object)v)) continue;
            this.vars.add(v);
        }
        this.rows.add(binding);
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public Iterator<Binding> rows() {
        return this.rows.iterator();
    }

    @Override
    public QueryIterator iterator(ExecutionContext execCxt) {
        return new QueryIterPlainWrapper(this.rows.iterator(), execCxt);
    }

    @Override
    public void closeTable() {
        this.rows = null;
    }

    @Override
    public List<String> getVarNames() {
        return Var.varNames(this.vars);
    }

    @Override
    public List<Var> getVars() {
        return this.vars;
    }
}

