/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.DynamicOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.query.lucene.constraint.SelectorBasedConstraint;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModelConstants;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;

public class ComparisonConstraint
extends SelectorBasedConstraint
implements QueryObjectModelConstants {
    private final DynamicOperand operand1;
    private final int operator;
    private final Value operand2;

    public ComparisonConstraint(DynamicOperand operand1, int operator, Value operand2, SelectorImpl selector) {
        super(selector);
        this.operand1 = operand1;
        this.operator = operator;
        this.operand2 = operand2;
    }

    public boolean evaluate(ScoreNode[] row, Name[] selectorNames, EvaluationContext context) throws IOException {
        ScoreNode sn = row[this.getSelectorIndex(selectorNames)];
        if (sn == null) {
            return false;
        }
        Value[] values = this.operand1.getValues(sn, context);
        try {
            for (int i = 0; i < values.length; ++i) {
                if (!this.evaluate(values[i])) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
        return false;
    }

    protected boolean evaluate(Value op1) throws RepositoryException {
        int c = Util.compare(op1, this.operand2);
        switch (this.operator) {
            case 201: {
                return c == 0;
            }
            case 205: {
                return c > 0;
            }
            case 206: {
                return c >= 0;
            }
            case 203: {
                return c < 0;
            }
            case 204: {
                return c <= 0;
            }
            case 202: {
                return c != 0;
            }
        }
        throw new IllegalStateException("unsupported operation: " + this.operator);
    }
}

