/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.master.balancer.FavoredNodesPlan;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class SnapshotOfRegionAssignmentFromMeta {
    private static final Log LOG = LogFactory.getLog((String)SnapshotOfRegionAssignmentFromMeta.class.getName());
    private CatalogTracker tracker;
    private final Map<TableName, List<HRegionInfo>> tableToRegionMap;
    private Map<HRegionInfo, ServerName> regionToRegionServerMap;
    private final Map<String, HRegionInfo> regionNameToRegionInfoMap;
    private final Map<ServerName, List<HRegionInfo>> regionServerToRegionMap;
    private final FavoredNodesPlan existingAssignmentPlan;
    private final Set<TableName> disabledTables;
    private final boolean excludeOfflinedSplitParents;

    public SnapshotOfRegionAssignmentFromMeta(CatalogTracker tracker) {
        this(tracker, new HashSet<TableName>(), false);
    }

    public SnapshotOfRegionAssignmentFromMeta(CatalogTracker tracker, Set<TableName> disabledTables, boolean excludeOfflinedSplitParents) {
        this.tracker = tracker;
        this.tableToRegionMap = new HashMap<TableName, List<HRegionInfo>>();
        this.regionToRegionServerMap = new HashMap<HRegionInfo, ServerName>();
        this.regionServerToRegionMap = new HashMap<ServerName, List<HRegionInfo>>();
        this.regionNameToRegionInfoMap = new TreeMap<String, HRegionInfo>();
        this.existingAssignmentPlan = new FavoredNodesPlan();
        this.disabledTables = disabledTables;
        this.excludeOfflinedSplitParents = excludeOfflinedSplitParents;
    }

    public void initialize() throws IOException {
        LOG.info((Object)"Start to scan the hbase:meta for the current region assignment snappshot");
        MetaReader.Visitor v = new MetaReader.Visitor(){

            public boolean visit(Result result) throws IOException {
                try {
                    if (result == null || result.isEmpty()) {
                        return true;
                    }
                    Pair regionAndServer = HRegionInfo.getHRegionInfoAndServerName((Result)result);
                    HRegionInfo hri = (HRegionInfo)regionAndServer.getFirst();
                    if (hri == null) {
                        return true;
                    }
                    if (hri.getTable() == null) {
                        return true;
                    }
                    if (SnapshotOfRegionAssignmentFromMeta.this.disabledTables.contains(hri.getTable())) {
                        return true;
                    }
                    if (SnapshotOfRegionAssignmentFromMeta.this.excludeOfflinedSplitParents && hri.isSplit()) {
                        return true;
                    }
                    SnapshotOfRegionAssignmentFromMeta.this.addAssignment(hri, (ServerName)regionAndServer.getSecond());
                    SnapshotOfRegionAssignmentFromMeta.this.addRegion(hri);
                    byte[] favoredNodes = result.getValue(HConstants.CATALOG_FAMILY, FavoredNodeAssignmentHelper.FAVOREDNODES_QUALIFIER);
                    if (favoredNodes == null) {
                        return true;
                    }
                    ServerName[] favoredServerList = FavoredNodeAssignmentHelper.getFavoredNodesList(favoredNodes);
                    SnapshotOfRegionAssignmentFromMeta.this.existingAssignmentPlan.updateFavoredNodesMap(hri, Arrays.asList(favoredServerList));
                    return true;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Catche remote exception " + e.getMessage() + " when processing" + result));
                    throw e;
                }
            }
        };
        MetaReader.fullScan((CatalogTracker)this.tracker, (MetaReader.Visitor)v);
        LOG.info((Object)"Finished to scan the hbase:meta for the current region assignmentsnapshot");
    }

    private void addRegion(HRegionInfo regionInfo) {
        this.regionNameToRegionInfoMap.put(regionInfo.getRegionNameAsString(), regionInfo);
        TableName tableName = regionInfo.getTable();
        List<HRegionInfo> regionList = this.tableToRegionMap.get(tableName);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(regionInfo);
        this.tableToRegionMap.put(tableName, regionList);
    }

    private void addAssignment(HRegionInfo regionInfo, ServerName server) {
        this.regionToRegionServerMap.put(regionInfo, server);
        List<HRegionInfo> regionList = this.regionServerToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(regionInfo);
        this.regionServerToRegionMap.put(server, regionList);
    }

    public Map<String, HRegionInfo> getRegionNameToRegionInfoMap() {
        return this.regionNameToRegionInfoMap;
    }

    public Map<TableName, List<HRegionInfo>> getTableToRegionMap() {
        return this.tableToRegionMap;
    }

    public Map<HRegionInfo, ServerName> getRegionToRegionServerMap() {
        return this.regionToRegionServerMap;
    }

    public Map<ServerName, List<HRegionInfo>> getRegionServerToRegionMap() {
        return this.regionServerToRegionMap;
    }

    public FavoredNodesPlan getExistingAssignmentPlan() {
        return this.existingAssignmentPlan;
    }

    public Set<TableName> getTableSet() {
        return this.tableToRegionMap.keySet();
    }
}

