/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationHLogReaderManager;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestReplicationHLogReaderManager {
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration conf;
    private static Path hbaseDir;
    private static FileSystem fs;
    private static MiniDFSCluster cluster;
    private static final TableName tableName;
    private static final byte[] family;
    private static final byte[] qualifier;
    private static final HRegionInfo info;
    private static final HTableDescriptor htd;
    private HLog log;
    private ReplicationHLogReaderManager logManager;
    private PathWatcher pathWatcher;
    private int nbRows;
    private int walEditKVs;
    private final AtomicLong sequenceId = new AtomicLong(1L);

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        int[] NB_ROWS = new int[]{1500, 60000};
        int[] NB_KVS = new int[]{1, 100};
        Boolean[] BOOL_VALS = new Boolean[]{false, true};
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int nbRows : NB_ROWS) {
            for (int walEditKVs : NB_KVS) {
                Boolean[] arr$ = BOOL_VALS;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    boolean b = arr$[i$];
                    Object[] arr = new Object[]{nbRows, walEditKVs, b};
                    parameters.add(arr);
                }
            }
        }
        return parameters;
    }

    public TestReplicationHLogReaderManager(int nbRows, int walEditKVs, boolean enableCompression) {
        this.nbRows = nbRows;
        this.walEditKVs = walEditKVs;
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.wal.enablecompression", enableCompression);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniDFSCluster(3);
        hbaseDir = TEST_UTIL.createRootDir();
        cluster = TEST_UTIL.getDFSCluster();
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.logManager = new ReplicationHLogReaderManager(fs, conf);
        ArrayList<PathWatcher> listeners = new ArrayList<PathWatcher>();
        this.pathWatcher = new PathWatcher();
        listeners.add(this.pathWatcher);
        this.log = HLogFactory.createHLog((FileSystem)fs, (Path)hbaseDir, (String)"test", (Configuration)conf, listeners, (String)"some server");
    }

    @After
    public void tearDown() throws Exception {
        this.log.closeAndDelete();
    }

    @Test
    public void test() throws Exception {
        int i;
        Path path = this.pathWatcher.currentPath;
        Assert.assertEquals((long)0L, (long)this.logManager.getPosition());
        this.appendToLog();
        Assert.assertNotNull((Object)this.logManager.openReader(path));
        this.logManager.seek();
        HLog.Entry entry = this.logManager.readNextAndSetPosition();
        Assert.assertNotNull((Object)entry);
        entry = this.logManager.readNextAndSetPosition();
        Assert.assertNull((Object)entry);
        this.logManager.closeReader();
        long oldPos = this.logManager.getPosition();
        this.appendToLog();
        Assert.assertNotNull((Object)this.logManager.openReader(path));
        this.logManager.seek();
        entry = this.logManager.readNextAndSetPosition();
        Assert.assertNotEquals((long)oldPos, (long)this.logManager.getPosition());
        Assert.assertNotNull((Object)entry);
        this.logManager.closeReader();
        oldPos = this.logManager.getPosition();
        this.log.rollWriter();
        Assert.assertNotNull((Object)this.logManager.openReader(path));
        this.logManager.seek();
        entry = this.logManager.readNextAndSetPosition();
        Assert.assertEquals((long)oldPos, (long)this.logManager.getPosition());
        Assert.assertNull((Object)entry);
        this.logManager.finishCurrentFile();
        path = this.pathWatcher.currentPath;
        for (i = 0; i < this.nbRows; ++i) {
            this.appendToLogPlus(this.walEditKVs);
        }
        this.log.rollWriter();
        this.logManager.openReader(path);
        this.logManager.seek();
        for (i = 0; i < this.nbRows; ++i) {
            HLog.Entry e = this.logManager.readNextAndSetPosition();
            if (e != null) continue;
            Assert.fail((String)"Should have enough entries");
        }
    }

    private void appendToLog() throws IOException {
        this.appendToLogPlus(1);
    }

    private void appendToLogPlus(int count) throws IOException {
        this.log.append(info, tableName, this.getWALEdits(count), System.currentTimeMillis(), htd, this.sequenceId);
    }

    private WALEdit getWALEdits(int count) {
        WALEdit edit = new WALEdit();
        for (int i = 0; i < count; ++i) {
            edit.add(new KeyValue(Bytes.toBytes((long)System.currentTimeMillis()), family, qualifier, System.currentTimeMillis(), qualifier));
        }
        return edit;
    }

    static {
        tableName = TableName.valueOf((String)"tablename");
        family = Bytes.toBytes((String)"column");
        qualifier = Bytes.toBytes((String)"qualifier");
        info = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.LAST_ROW, false);
        htd = new HTableDescriptor(tableName);
    }

    class PathWatcher
    implements WALActionsListener {
        Path currentPath;

        PathWatcher() {
        }

        public void preLogRoll(Path oldPath, Path newPath) throws IOException {
            this.currentPath = newPath;
        }

        public void postLogRoll(Path oldPath, Path newPath) throws IOException {
        }

        public void preLogArchive(Path oldPath, Path newPath) throws IOException {
        }

        public void postLogArchive(Path oldPath, Path newPath) throws IOException {
        }

        public void logRollRequested(boolean tooFewReplicas) {
        }

        public void logCloseRequested() {
        }

        public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
        }

        public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
        }
    }
}

