/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.TestLogRolling;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestLogRollAbort {
    private static final Log LOG = LogFactory.getLog(TestLogRolling.class);
    private static MiniDFSCluster dfsCluster;
    private static HBaseAdmin admin;
    private static MiniHBaseCluster cluster;
    private static final HBaseTestingUtility TEST_UTIL;

    public TestLogRollAbort() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hdfs.server.namenode.FSNamesystem")).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)HRegionServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)HRegion.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)HLog.LOG).getLogger().setLevel(Level.ALL);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.ping.interval", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.socket.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 5000L);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("heartbeat.recheck.interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.write.retries", 10);
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        cluster = TEST_UTIL.getHBaseCluster();
        dfsCluster = TEST_UTIL.getDFSCluster();
        admin = TEST_UTIL.getHBaseAdmin();
        cluster.getMaster().balanceSwitch(false);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRSAbortWithUnflushedEdits() throws Exception {
        LOG.info((Object)"Starting testRSAbortWithUnflushedEdits()");
        new HTable(TEST_UTIL.getConfiguration(), TableName.META_TABLE_NAME).close();
        String tableName = this.getClass().getSimpleName();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        desc.setDeferredLogFlush(true);
        admin.createTable(desc);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(Bytes.toBytes((String)tableName));
        HLog log = server.getWAL();
        Assert.assertTrue((String)"Need HDFS-826 for this test", (boolean)((FSHLog)log).canGetCurReplicas());
        Assert.assertTrue((String)"Need append support for this test", (boolean)FSUtils.isAppendSupported((Configuration)TEST_UTIL.getConfiguration()));
        Put p = new Put(Bytes.toBytes((String)"row2001"));
        p.add(HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"col"), Bytes.toBytes((int)2001));
        table.put(p);
        log.sync();
        p = new Put(Bytes.toBytes((String)"row2002"));
        p.add(HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"col"), Bytes.toBytes((int)2002));
        table.put(p);
        dfsCluster.restartDataNodes();
        LOG.info((Object)"Restarted datanodes");
        try {
            log.rollWriter(true);
        }
        catch (FailedLogCloseException flce) {
            Assert.assertTrue((String)"Should have deferred flush log edits outstanding", (boolean)((FSHLog)log).hasUnSyncedEntries());
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
    }
}

