/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class})
public class TestSeekOptimizations {
    private static final Log LOG = LogFactory.getLog(TestSeekOptimizations.class);
    private static final String FAMILY = "myCF";
    private static final byte[] FAMILY_BYTES = Bytes.toBytes((String)"myCF");
    private static final int PUTS_PER_ROW_COL = 50;
    private static final int DELETES_PER_ROW_COL = 10;
    private static final int NUM_ROWS = 3;
    private static final int NUM_COLS = 3;
    private static final boolean VERBOSE = false;
    private static final boolean USE_MANY_STORE_FILES = true;
    private static final int[][] COLUMN_SETS = new int[][]{new int[0], {0}, {1}, {0, 2}, {1, 2}, {0, 1, 2}};
    private static final int[][] ROW_RANGES = new int[][]{{-1, -1}, {0, 1}, {1, 1}, {1, 2}, {0, 2}};
    private static final int[] MAX_VERSIONS_VALUES = new int[]{1, 2};
    private HRegion region;
    private Put put;
    private Delete del;
    private Random rand;
    private Set<Long> putTimestamps = new HashSet<Long>();
    private Set<Long> delTimestamps = new HashSet<Long>();
    private List<Cell> expectedKVs = new ArrayList<Cell>();
    private Compression.Algorithm comprAlgo;
    private BloomType bloomType;
    private long totalSeekDiligent;
    private long totalSeekLazy;
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();

    @Parameterized.Parameters
    public static final Collection<Object[]> parameters() {
        return HBaseTestingUtility.BLOOM_AND_COMPRESSION_COMBINATIONS;
    }

    public TestSeekOptimizations(Compression.Algorithm comprAlgo, BloomType bloomType) {
        this.comprAlgo = comprAlgo;
        this.bloomType = bloomType;
    }

    @Before
    public void setUp() {
        this.rand = new Random(91238123L);
        this.expectedKVs.clear();
    }

    @Test
    public void testMultipleTimestampRanges() throws IOException {
        StoreFileScanner.instrument();
        this.region = TEST_UTIL.createTestRegion("testMultipleTimestampRanges", new HColumnDescriptor(FAMILY).setCompressionType(this.comprAlgo).setBloomFilterType(this.bloomType).setMaxVersions(3));
        long latestDelTS = 1397L;
        this.createTimestampRange(1L, 50L, -1L);
        this.createTimestampRange(51L, 100L, -1L);
        this.createTimestampRange(100L, 500L, 127L);
        this.createTimestampRange(900L, 1300L, -1L);
        this.createTimestampRange(1301L, 2500L, 1397L);
        this.createTimestampRange(2502L, 2598L, -1L);
        this.createTimestampRange(2599L, 2999L, -1L);
        this.prepareExpectedKVs(1397L);
        for (int[] columnArr : COLUMN_SETS) {
            for (int[] rowRange : ROW_RANGES) {
                for (int maxVersions : MAX_VERSIONS_VALUES) {
                    for (boolean lazySeekEnabled : new boolean[]{false, true}) {
                        this.testScan(columnArr, lazySeekEnabled, rowRange[0], rowRange[1], maxVersions);
                    }
                }
            }
        }
        double seekSavings = 1.0 - (double)this.totalSeekLazy * 1.0 / (double)this.totalSeekDiligent;
        System.err.println("For bloom=" + this.bloomType + ", compr=" + this.comprAlgo + " total seeks without optimization: " + this.totalSeekDiligent + ", with optimization: " + this.totalSeekLazy + " (" + String.format("%.2f%%", (double)this.totalSeekLazy * 100.0 / (double)this.totalSeekDiligent) + "), savings: " + String.format("%.2f%%", 100.0 * seekSavings) + "\n");
        double expectedSeekSavings = 0.0;
        Assert.assertTrue((String)("Lazy seek is only saving " + String.format("%.2f%%", seekSavings * 100.0) + " seeks but should " + "save at least " + String.format("%.2f%%", 0.0)), (seekSavings >= 0.0 ? 1 : 0) != 0);
    }

    private void testScan(int[] columnArr, boolean lazySeekEnabled, int startRow, int endRow, int maxVersions) throws IOException {
        boolean hasNext;
        StoreScanner.enableLazySeekGlobally((boolean)lazySeekEnabled);
        Scan scan = new Scan();
        HashSet<String> qualSet = new HashSet<String>();
        for (int iColumn : columnArr) {
            String qualStr = this.getQualStr(iColumn);
            scan.addColumn(FAMILY_BYTES, Bytes.toBytes((String)qualStr));
            qualSet.add(qualStr);
        }
        scan.setMaxVersions(maxVersions);
        scan.setStartRow(this.rowBytes(startRow));
        byte[] scannerStopRow = this.rowBytes(endRow + (startRow != endRow ? 1 : 0));
        scan.setStopRow(scannerStopRow);
        long initialSeekCount = StoreFileScanner.getSeekCount();
        RegionScanner scanner = this.region.getScanner(scan);
        ArrayList results = new ArrayList();
        ArrayList actualKVs = new ArrayList();
        do {
            hasNext = scanner.next(results);
            actualKVs.addAll(results);
            results.clear();
        } while (hasNext);
        List<Cell> filteredKVs = this.filterExpectedResults(qualSet, this.rowBytes(startRow), this.rowBytes(endRow), maxVersions);
        String rowRestrictionStr = startRow == -1 && endRow == -1 ? "all rows" : (startRow == endRow ? "row=" + startRow : "startRow=" + startRow + ", " + "endRow=" + endRow);
        String columnRestrictionStr = columnArr.length == 0 ? "all columns" : "columns=" + Arrays.toString(columnArr);
        String testDesc = "Bloom=" + this.bloomType + ", compr=" + this.comprAlgo + ", " + (scan.isGetScan() ? "Get" : "Scan") + ": " + columnRestrictionStr + ", " + rowRestrictionStr + ", maxVersions=" + maxVersions + ", lazySeek=" + lazySeekEnabled;
        long seekCount = StoreFileScanner.getSeekCount() - initialSeekCount;
        if (lazySeekEnabled) {
            this.totalSeekLazy += seekCount;
        } else {
            this.totalSeekDiligent += seekCount;
        }
        HBaseTestingUtility.assertKVListsEqual(testDesc, filteredKVs, actualKVs);
    }

    private List<Cell> filterExpectedResults(Set<String> qualSet, byte[] startRow, byte[] endRow, int maxVersions) {
        ArrayList<Cell> filteredKVs = new ArrayList<Cell>();
        HashMap<String, Integer> verCount = new HashMap<String, Integer>();
        for (Cell kv : this.expectedKVs) {
            String rowColStr;
            Integer curNumVer;
            int newNumVer;
            if (startRow.length > 0 && Bytes.compareTo((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])startRow, (int)0, (int)startRow.length) < 0 || endRow.length > 0 && Bytes.compareTo((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])endRow, (int)0, (int)endRow.length) > 0 || !qualSet.isEmpty() && (!CellUtil.matchingFamily((Cell)kv, (byte[])FAMILY_BYTES) || !qualSet.contains(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)))) || (newNumVer = (curNumVer = (Integer)verCount.get(rowColStr = Bytes.toStringBinary((byte[])CellUtil.cloneRow((Cell)kv)) + "/" + Bytes.toStringBinary((byte[])CellUtil.cloneFamily((Cell)kv)) + ":" + Bytes.toStringBinary((byte[])CellUtil.cloneQualifier((Cell)kv)))) != null ? curNumVer + 1 : 1) > maxVersions) continue;
            filteredKVs.add(kv);
            verCount.put(rowColStr, newNumVer);
        }
        return filteredKVs;
    }

    private void prepareExpectedKVs(long latestDelTS) {
        ArrayList<Cell> filteredKVs = new ArrayList<Cell>();
        for (Cell kv : this.expectedKVs) {
            if (kv.getTimestamp() <= latestDelTS && latestDelTS != -1L) continue;
            filteredKVs.add(kv);
        }
        this.expectedKVs = filteredKVs;
        Collections.sort(this.expectedKVs, KeyValue.COMPARATOR);
    }

    public void put(String qual, long ts) {
        if (!this.putTimestamps.contains(ts)) {
            this.put.add(FAMILY_BYTES, Bytes.toBytes((String)qual), ts, this.createValue(ts));
            this.putTimestamps.add(ts);
        }
    }

    private byte[] createValue(long ts) {
        return Bytes.toBytes((String)("value" + ts));
    }

    public void delAtTimestamp(String qual, long ts) {
        this.del.deleteColumn(FAMILY_BYTES, Bytes.toBytes((String)qual), ts);
        this.logDelete(qual, ts, "at");
    }

    private void logDelete(String qual, long ts, String delType) {
    }

    private void delUpToTimestamp(String qual, long upToTS) {
        this.del.deleteColumns(FAMILY_BYTES, Bytes.toBytes((String)qual), upToTS);
        this.logDelete(qual, upToTS, "up to and including");
    }

    private long randLong(long n) {
        long l = this.rand.nextLong();
        if (l == Long.MIN_VALUE) {
            l = Long.MAX_VALUE;
        }
        return Math.abs(l) % n;
    }

    private long randBetween(long a, long b) {
        long x = a + this.randLong(b - a + 1L);
        Assert.assertTrue((a <= x && x <= b ? 1 : 0) != 0);
        return x;
    }

    private final String rowStr(int i) {
        return ("row" + i).intern();
    }

    private final byte[] rowBytes(int i) {
        if (i == -1) {
            return HConstants.EMPTY_BYTE_ARRAY;
        }
        return Bytes.toBytes((String)this.rowStr(i));
    }

    private final String getQualStr(int i) {
        return ("qual" + i).intern();
    }

    public void createTimestampRange(long minTS, long maxTS, long deleteUpToTS) throws IOException {
        Assert.assertTrue((minTS < maxTS ? 1 : 0) != 0);
        Assert.assertTrue((deleteUpToTS == -1L || minTS <= deleteUpToTS && deleteUpToTS <= maxTS ? 1 : 0) != 0);
        for (int iRow = 0; iRow < 3; ++iRow) {
            String row = this.rowStr(iRow);
            byte[] rowBytes = Bytes.toBytes((String)row);
            for (int iCol = 0; iCol < 3; ++iCol) {
                String qual = this.getQualStr(iCol);
                byte[] qualBytes = Bytes.toBytes((String)qual);
                this.put = new Put(rowBytes);
                this.putTimestamps.clear();
                this.put(qual, minTS);
                this.put(qual, maxTS);
                for (int i = 0; i < 50; ++i) {
                    this.put(qual, this.randBetween(minTS, maxTS));
                }
                long[] putTimestampList = new long[this.putTimestamps.size()];
                int i = 0;
                for (long ts : this.putTimestamps) {
                    putTimestampList[i++] = ts;
                }
                this.delTimestamps.clear();
                Assert.assertTrue((putTimestampList.length >= 10 ? 1 : 0) != 0);
                int numToDel = 10;
                int tsRemaining = putTimestampList.length;
                this.del = new Delete(rowBytes);
                for (long ts : putTimestampList) {
                    if (this.rand.nextInt(tsRemaining) < numToDel) {
                        this.delAtTimestamp(qual, ts);
                        this.putTimestamps.remove(ts);
                        --numToDel;
                    }
                    if (--tsRemaining == 0) break;
                }
                if (deleteUpToTS != -1L) {
                    this.delUpToTimestamp(qual, deleteUpToTS);
                }
                this.region.put(this.put);
                if (!this.del.isEmpty()) {
                    this.region.delete(this.del);
                }
                for (long ts : this.putTimestamps) {
                    this.expectedKVs.add((Cell)new KeyValue(rowBytes, FAMILY_BYTES, qualBytes, ts, KeyValue.Type.Put));
                }
            }
        }
        this.region.flushcache();
    }

    @After
    public void tearDown() throws IOException {
        if (this.region != null) {
            HRegion.closeHRegion((HRegion)this.region);
        }
        StoreScanner.enableLazySeekGlobally((boolean)true);
    }
}

