/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSCVFWithMiniCluster {
    private static final String HBASE_TABLE_NAME = "TestSCVFWithMiniCluster";
    private static final byte[] FAMILY_A = Bytes.toBytes((String)"a");
    private static final byte[] FAMILY_B = Bytes.toBytes((String)"b");
    private static final byte[] QUALIFIER_FOO = Bytes.toBytes((String)"foo");
    private static final byte[] QUALIFIER_BAR = Bytes.toBytes((String)"bar");
    private static HTable htable;
    private static Filter scanFilter;
    private int expected = 1;

    @BeforeClass
    public static void setUp() throws Exception {
        HBaseTestingUtility util = new HBaseTestingUtility();
        util.startMiniCluster(1);
        HBaseAdmin admin = util.getHBaseAdmin();
        TestSCVFWithMiniCluster.destroy(admin, HBASE_TABLE_NAME);
        TestSCVFWithMiniCluster.create(admin, HBASE_TABLE_NAME, FAMILY_A, FAMILY_B);
        admin.close();
        htable = new HTable(util.getConfiguration(), HBASE_TABLE_NAME);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put = new Put(Bytes.toBytes((String)"1"));
        put.setDurability(Durability.SKIP_WAL);
        put.add(FAMILY_A, QUALIFIER_FOO, Bytes.toBytes((String)"false"));
        put.add(FAMILY_A, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        put.add(FAMILY_B, QUALIFIER_FOO, Bytes.toBytes((String)"_flag_"));
        put.add(FAMILY_B, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"2"));
        put.setDurability(Durability.SKIP_WAL);
        put.add(FAMILY_A, QUALIFIER_FOO, Bytes.toBytes((String)"true"));
        put.add(FAMILY_A, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        put.add(FAMILY_B, QUALIFIER_FOO, Bytes.toBytes((String)"_flag_"));
        put.add(FAMILY_B, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"3"));
        put.setDurability(Durability.SKIP_WAL);
        put.add(FAMILY_A, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        put.add(FAMILY_B, QUALIFIER_FOO, Bytes.toBytes((String)"_flag_"));
        put.add(FAMILY_B, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        puts.add(put);
        htable.put(puts);
        scanFilter = new SingleColumnValueFilter(FAMILY_A, QUALIFIER_FOO, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"false")));
        ((SingleColumnValueFilter)scanFilter).setFilterIfMissing(true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        htable.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(Scan scan) throws IOException {
        ResultScanner scanner = htable.getScanner(scan);
        Iterator it = scanner.iterator();
        int count = 0;
        try {
            while (it.hasNext()) {
                it.next();
                ++count;
            }
        }
        finally {
            scanner.close();
        }
        Assert.assertEquals((int)this.expected, (int)count);
    }

    @Test
    public void scanWithAllQualifiersOfFamiliyA() throws IOException {
        Scan scan = new Scan();
        scan.addFamily(FAMILY_A);
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    @Test
    public void scanWithAllQualifiersOfBothFamilies() throws IOException {
        Scan scan = new Scan();
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    @Test
    public void scanWithSpecificQualifiers1() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(FAMILY_A, QUALIFIER_FOO);
        scan.addColumn(FAMILY_A, QUALIFIER_BAR);
        scan.addColumn(FAMILY_B, QUALIFIER_BAR);
        scan.addColumn(FAMILY_B, QUALIFIER_FOO);
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    @Test
    public void scanWithSpecificQualifiers2() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(FAMILY_A, QUALIFIER_FOO);
        scan.addColumn(FAMILY_B, QUALIFIER_BAR);
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    @Test
    public void scanWithSpecificQualifiers3() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(FAMILY_A, QUALIFIER_FOO);
        scan.addColumn(FAMILY_A, QUALIFIER_BAR);
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    private static void create(HBaseAdmin admin, String tableName, byte[] ... families) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
        for (byte[] family : families) {
            HColumnDescriptor colDesc = new HColumnDescriptor(family);
            colDesc.setMaxVersions(1);
            colDesc.setCompressionType(Compression.Algorithm.GZ);
            desc.addFamily(colDesc);
        }
        try {
            admin.createTable(desc);
        }
        catch (TableExistsException tee) {
            // empty catch block
        }
    }

    private static void destroy(HBaseAdmin admin, String tableName) throws IOException {
        try {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }
}

