/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class})
public class TestMultiColumnScanner {
    private static final Log LOG = LogFactory.getLog(TestMultiColumnScanner.class);
    private static final String TABLE_NAME = TestMultiColumnScanner.class.getSimpleName();
    static final int MAX_VERSIONS = 50;
    private static final String FAMILY = "CF";
    private static final byte[] FAMILY_BYTES = Bytes.toBytes((String)"CF");
    private static final int NUM_COLUMNS = 8;
    private static final int MAX_COLUMN_BIT_MASK = 128;
    private static final int NUM_FLUSHES = 10;
    private static final int NUM_ROWS = 20;
    private static final long BIG_LONG = 9111222333444555666L;
    private static final long[] TIMESTAMPS = new long[]{1L, 3L, 5L, Integer.MAX_VALUE, 9111222333444555666L, 0x7FFFFFFFFFFFFFFEL};
    private static final double COLUMN_SKIP_IN_STORE_FILE_PROB = 0.7;
    private static final double COLUMN_SKIP_IN_ROW_PROB = 0.1;
    private static final double COLUMN_SKIP_EVERYWHERE_PROB = 0.1;
    private static final double DELETE_PROBABILITY = 0.02;
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private final Compression.Algorithm comprAlgo;
    private final BloomType bloomType;
    private final DataBlockEncoding dataBlockEncoding;

    @Parameterized.Parameters
    public static final Collection<Object[]> parameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (Object[] bloomAndCompressionParams : HBaseTestingUtility.BLOOM_AND_COMPRESSION_COMBINATIONS) {
            for (boolean useDataBlockEncoding : new boolean[]{false, true}) {
                parameters.add(ArrayUtils.add((Object[])bloomAndCompressionParams, (Object)useDataBlockEncoding));
            }
        }
        return parameters;
    }

    public TestMultiColumnScanner(Compression.Algorithm comprAlgo, BloomType bloomType, boolean useDataBlockEncoding) {
        this.comprAlgo = comprAlgo;
        this.bloomType = bloomType;
        this.dataBlockEncoding = useDataBlockEncoding ? DataBlockEncoding.PREFIX : DataBlockEncoding.NONE;
    }

    @Test
    public void testMultiColumnScanner() throws IOException {
        HRegion region = TEST_UTIL.createTestRegion(TABLE_NAME, new HColumnDescriptor(FAMILY).setCompressionType(this.comprAlgo).setBloomFilterType(this.bloomType).setMaxVersions(50).setDataBlockEncoding(this.dataBlockEncoding));
        List<String> rows = TestMultiColumnScanner.sequentialStrings("row", 20);
        List<String> qualifiers = TestMultiColumnScanner.sequentialStrings("qual", 8);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        HashSet<String> keySet = new HashSet<String>();
        HashMap<String, Long> lastDelTimeMap = new HashMap<String, Long>();
        Random rand = new Random(29372937L);
        HashSet<String> rowQualSkip = new HashSet<String>();
        for (String row : rows) {
            for (String qual : qualifiers) {
                if (!(rand.nextDouble() < 0.1)) continue;
                LOG.info((Object)("Skipping " + qual + " in row " + row));
                rowQualSkip.add(TestMultiColumnScanner.rowQualKey(row, qual));
            }
        }
        for (String qual : qualifiers) {
            if (!(rand.nextDouble() < 0.1)) continue;
            LOG.info((Object)("Skipping " + qual + " in all rows"));
            for (String row : rows) {
                rowQualSkip.add(TestMultiColumnScanner.rowQualKey(row, qual));
            }
        }
        for (int iFlush = 0; iFlush < 10; ++iFlush) {
            for (String qual : qualifiers) {
                if (rand.nextDouble() < 0.7) continue;
                byte[] qualBytes = Bytes.toBytes((String)qual);
                for (String row : rows) {
                    Put p = new Put(Bytes.toBytes((String)row));
                    for (long ts : TIMESTAMPS) {
                        String value = TestMultiColumnScanner.createValue(row, qual, ts);
                        KeyValue kv = KeyValueTestUtil.create((String)row, (String)FAMILY, (String)qual, (long)ts, (String)value);
                        Assert.assertEquals((long)kv.getTimestamp(), (long)ts);
                        p.add((Cell)kv);
                        String keyAsString = kv.toString();
                        if (keySet.contains(keyAsString)) continue;
                        keySet.add(keyAsString);
                        kvs.add(kv);
                    }
                    region.put(p);
                    Delete d = new Delete(Bytes.toBytes((String)row));
                    boolean deletedSomething = false;
                    for (long ts : TIMESTAMPS) {
                        if (!(rand.nextDouble() < 0.02)) continue;
                        d.deleteColumns(FAMILY_BYTES, qualBytes, ts);
                        String rowAndQual = row + "_" + qual;
                        Long whenDeleted = (Long)lastDelTimeMap.get(rowAndQual);
                        lastDelTimeMap.put(rowAndQual, whenDeleted == null ? ts : Math.max(ts, whenDeleted));
                        deletedSomething = true;
                    }
                    if (!deletedSomething) continue;
                    region.delete(d);
                }
            }
            region.flushcache();
        }
        Collections.sort(kvs, KeyValue.COMPARATOR);
        for (int maxVersions = 1; maxVersions <= TIMESTAMPS.length; ++maxVersions) {
            for (int columnBitMask = 1; columnBitMask <= 128; ++columnBitMask) {
                Scan scan = new Scan();
                scan.setMaxVersions(maxVersions);
                TreeSet<String> qualSet = new TreeSet<String>();
                int columnMaskTmp = columnBitMask;
                for (String qual : qualifiers) {
                    if ((columnMaskTmp & 1) != 0) {
                        scan.addColumn(FAMILY_BYTES, Bytes.toBytes((String)qual));
                        qualSet.add(qual);
                    }
                    columnMaskTmp >>= 1;
                }
                Assert.assertEquals((long)0L, (long)columnMaskTmp);
                RegionScanner scanner = region.getScanner(scan);
                ArrayList results = new ArrayList();
                int kvPos = 0;
                int numResults = 0;
                String queryInfo = "columns queried: " + qualSet + " (columnBitMask=" + columnBitMask + "), maxVersions=" + maxVersions;
                while (scanner.next(results) || results.size() > 0) {
                    for (Cell kv : results) {
                        while (kvPos < kvs.size() && !TestMultiColumnScanner.matchesQuery((KeyValue)kvs.get(kvPos), qualSet, maxVersions, lastDelTimeMap)) {
                            ++kvPos;
                        }
                        String rowQual = TestMultiColumnScanner.getRowQualStr(kv);
                        String deleteInfo = "";
                        Long lastDelTS = (Long)lastDelTimeMap.get(rowQual);
                        if (lastDelTS != null) {
                            deleteInfo = "; last timestamp when row/column " + rowQual + " was deleted: " + lastDelTS;
                        }
                        Assert.assertTrue((String)("Scanner returned additional key/value: " + kv + ", " + queryInfo + deleteInfo + ";"), (kvPos < kvs.size() ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Scanner returned wrong key/value; " + queryInfo + deleteInfo + ";"), (boolean)CellComparator.equalsIgnoreMvccVersion((Cell)((Cell)kvs.get(kvPos)), (Cell)kv));
                        ++kvPos;
                        ++numResults;
                    }
                    results.clear();
                }
                while (kvPos < kvs.size()) {
                    KeyValue remainingKV = (KeyValue)kvs.get(kvPos);
                    Assert.assertFalse((String)("Matching column not returned by scanner: " + remainingKV + ", " + queryInfo + ", results returned: " + numResults), (boolean)TestMultiColumnScanner.matchesQuery(remainingKV, qualSet, maxVersions, lastDelTimeMap));
                    ++kvPos;
                }
            }
        }
        Assert.assertTrue((String)"This test is supposed to delete at least some row/column pairs", (lastDelTimeMap.size() > 0 ? 1 : 0) != 0);
        LOG.info((Object)("Number of row/col pairs deleted at least once: " + lastDelTimeMap.size()));
        HRegion.closeHRegion((HRegion)region);
    }

    private static String getRowQualStr(Cell kv) {
        String rowStr = Bytes.toString((byte[])CellUtil.cloneRow((Cell)kv));
        String qualStr = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv));
        return rowStr + "_" + qualStr;
    }

    private static boolean matchesQuery(KeyValue kv, Set<String> qualSet, int maxVersions, Map<String, Long> lastDelTimeMap) {
        Long lastDelTS = lastDelTimeMap.get(TestMultiColumnScanner.getRowQualStr((Cell)kv));
        long ts = kv.getTimestamp();
        return qualSet.contains(TestMultiColumnScanner.qualStr(kv)) && ts >= TIMESTAMPS[TIMESTAMPS.length - maxVersions] && (lastDelTS == null || ts > lastDelTS);
    }

    private static String qualStr(KeyValue kv) {
        return Bytes.toString((byte[])kv.getBuffer(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength());
    }

    private static String rowQualKey(String row, String qual) {
        return row + "_" + qual;
    }

    static String createValue(String row, String qual, long ts) {
        return "value_for_" + row + "_" + qual + "_" + ts;
    }

    private static List<String> sequentialStrings(String prefix, int n) {
        ArrayList<String> lst = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix + i);
            for (int iBitShifted = i; iBitShifted != 0; iBitShifted >>= 1) {
                sb.append((iBitShifted & 1) == 0 ? (char)'a' : 'b');
            }
            lst.add(sb.toString());
        }
        return lst;
    }

    static {
        Assert.assertTrue((boolean)true);
        for (int i = 0; i < TIMESTAMPS.length - 1; ++i) {
            Assert.assertTrue((TIMESTAMPS[i] < TIMESTAMPS[i + 1] ? 1 : 0) != 0);
        }
    }
}

