/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.IdentityTableReduce;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TestTableMapReduceBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableMapReduce
extends TestTableMapReduceBase {
    private static final Log LOG = LogFactory.getLog((String)TestTableMapReduce.class.getName());

    @Override
    protected Log getLog() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTestOnTable(HTable table) throws IOException {
        JobConf jobConf = null;
        try {
            LOG.info((Object)"Before map/reduce startup");
            jobConf = new JobConf(UTIL.getConfiguration(), TestTableMapReduce.class);
            jobConf.setJobName("process column contents");
            jobConf.setNumReduceTasks(1);
            TableMapReduceUtil.initTableMapJob((String)Bytes.toString((byte[])table.getTableName()), (String)Bytes.toString((byte[])INPUT_FAMILY), ProcessContentsMapper.class, ImmutableBytesWritable.class, Put.class, (JobConf)jobConf);
            TableMapReduceUtil.initTableReduceJob((String)Bytes.toString((byte[])table.getTableName()), IdentityTableReduce.class, (JobConf)jobConf);
            LOG.info((Object)("Started " + Bytes.toString((byte[])table.getTableName())));
            RunningJob job = JobClient.runJob((JobConf)jobConf);
            Assert.assertTrue((boolean)job.isSuccessful());
            LOG.info((Object)"After map/reduce completion");
            this.verify(Bytes.toString((byte[])table.getTableName()));
        }
        finally {
            if (jobConf != null) {
                FileUtil.fullyDelete((File)new File(jobConf.get("hadoop.tmp.dir")));
            }
        }
    }

    static class ProcessContentsMapper
    extends MapReduceBase
    implements TableMap<ImmutableBytesWritable, Put> {
        ProcessContentsMapper() {
        }

        public void map(ImmutableBytesWritable key, Result value, OutputCollector<ImmutableBytesWritable, Put> output, Reporter reporter) throws IOException {
            output.collect((Object)key, (Object)TestTableMapReduce.map(key, value));
        }
    }
}

