/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZKNamespaceManager;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestNamespace {
    protected static final Log LOG = LogFactory.getLog(TestNamespace.class);
    private static HMaster master;
    protected static final int NUM_SLAVES_BASE = 4;
    private static HBaseTestingUtility TEST_UTIL;
    protected static HBaseAdmin admin;
    protected static HBaseCluster cluster;
    private static ZKNamespaceManager zkNamespaceManager;
    private String prefix = "TestNamespace";

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().setInt("hbase.namespacejanitor.interval", 5000);
        TEST_UTIL.startMiniCluster(4);
        admin = TEST_UTIL.getHBaseAdmin();
        cluster = TEST_UTIL.getHBaseCluster();
        master = ((MiniHBaseCluster)cluster).getMaster();
        zkNamespaceManager = new ZKNamespaceManager(master.getZooKeeperWatcher());
        zkNamespaceManager.start();
        LOG.info((Object)"Done initializing cluster");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void beforeMethod() throws IOException {
        for (HTableDescriptor hTableDescriptor : admin.listTables(this.prefix + ".*")) {
            admin.disableTable(hTableDescriptor.getTableName());
            admin.deleteTable(hTableDescriptor.getTableName());
        }
        for (HTableDescriptor hTableDescriptor : admin.listNamespaceDescriptors()) {
            if (!hTableDescriptor.getName().startsWith(this.prefix)) continue;
            admin.deleteNamespace(hTableDescriptor.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyReservedNS() throws IOException {
        NamespaceDescriptor ns = admin.getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE.getName());
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)ns.getName(), (Object)NamespaceDescriptor.DEFAULT_NAMESPACE.getName());
        Assert.assertNotNull((Object)zkNamespaceManager.get(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR));
        ns = admin.getNamespaceDescriptor(NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)ns.getName(), (Object)NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        Assert.assertNotNull((Object)zkNamespaceManager.get(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR));
        Assert.assertEquals((long)2L, (long)admin.listNamespaceDescriptors().length);
        HashSet systemTables = Sets.newHashSet((Object[])new TableName[]{TableName.META_TABLE_NAME, TableName.NAMESPACE_TABLE_NAME});
        HTableDescriptor[] descs = admin.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        Assert.assertEquals((long)systemTables.size(), (long)descs.length);
        for (HTableDescriptor desc : descs) {
            Assert.assertTrue((boolean)systemTables.contains(desc.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)admin.listTables().length);
        boolean exceptionCaught = false;
        try {
            admin.createNamespace(NamespaceDescriptor.DEFAULT_NAMESPACE);
        }
        catch (IOException exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
        exceptionCaught = false;
        try {
            admin.createNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE);
        }
        catch (IOException exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteReservedNS() throws Exception {
        boolean exceptionCaught = false;
        try {
            admin.deleteNamespace(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR);
        }
        catch (IOException exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
        try {
            admin.deleteNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR);
        }
        catch (IOException exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    @Test
    public void createRemoveTest() throws Exception {
        String testName = "createRemoveTest";
        String nsName = this.prefix + "_" + testName;
        LOG.info((Object)testName);
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        Assert.assertEquals((long)3L, (long)admin.listNamespaceDescriptors().length);
        TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return zkNamespaceManager.list().size() == 3;
            }
        });
        Assert.assertNotNull((Object)zkNamespaceManager.get(nsName));
        admin.deleteNamespace(nsName);
        Assert.assertEquals((long)2L, (long)admin.listNamespaceDescriptors().length);
        Assert.assertEquals((long)2L, (long)zkNamespaceManager.list().size());
        Assert.assertNull((Object)zkNamespaceManager.get(nsName));
    }

    @Test
    public void createDoubleTest() throws IOException, InterruptedException {
        String testName = "createDoubleTest";
        String nsName = this.prefix + "_" + testName;
        LOG.info((Object)testName);
        byte[] tableName = Bytes.toBytes((String)"my_table");
        byte[] tableNameFoo = Bytes.toBytes((String)(nsName + ":my_table"));
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)nsName));
        TEST_UTIL.createTable(tableNameFoo, Bytes.toBytes((String)nsName));
        Assert.assertEquals((long)2L, (long)admin.listTables().length);
        Assert.assertNotNull((Object)admin.getTableDescriptor(tableName));
        Assert.assertNotNull((Object)admin.getTableDescriptor(tableNameFoo));
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
        Assert.assertEquals((long)1L, (long)admin.listTables().length);
    }

    @Test
    public void createTableTest() throws IOException, InterruptedException {
        String testName = "createTableTest";
        String nsName = this.prefix + "_" + testName;
        LOG.info((Object)testName);
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)(nsName + ":my_table")));
        HColumnDescriptor colDesc = new HColumnDescriptor("my_cf");
        desc.addFamily(colDesc);
        try {
            admin.createTable(desc);
            Assert.fail((String)"Expected no namespace exists exception");
        }
        catch (NamespaceNotFoundException ex) {
            // empty catch block
        }
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        admin.createTable(desc);
        TEST_UTIL.waitTableAvailable(desc.getTableName().getName(), 10000L);
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Assert.assertTrue((boolean)fs.exists(new Path(master.getMasterFileSystem().getRootDir(), new Path("data", new Path(nsName, desc.getTableName().getQualifierAsString())))));
        Assert.assertEquals((long)1L, (long)admin.listTables().length);
        try {
            admin.deleteNamespace(nsName);
            Assert.fail((String)"Expected non-empty namespace constraint exception");
        }
        catch (Exception ex) {
            LOG.info((Object)("Caught expected exception: " + ex));
        }
        HTable table = new HTable(TEST_UTIL.getConfiguration(), desc.getTableName());
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.add(Bytes.toBytes((String)"my_cf"), Bytes.toBytes((String)"my_col"), Bytes.toBytes((String)"value1"));
        table.put(p);
        admin.flush(desc.getTableName().getName());
        Get g = new Get(Bytes.toBytes((String)"row1"));
        Assert.assertTrue((boolean)table.exists(g));
        TEST_UTIL.deleteTable(desc.getTableName());
        admin.deleteNamespace(nsName);
    }

    @Test
    public void createTableInDefaultNamespace() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"default_table"));
        HColumnDescriptor colDesc = new HColumnDescriptor("cf1");
        desc.addFamily(colDesc);
        admin.createTable(desc);
        Assert.assertTrue((admin.listTables().length == 1 ? 1 : 0) != 0);
        admin.disableTable(desc.getTableName());
        admin.deleteTable(desc.getTableName());
    }

    @Test
    public void createTableInSystemNamespace() throws Exception {
        String tableName = "hbase:createTableInSystemNamespace";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
        HColumnDescriptor colDesc = new HColumnDescriptor("cf1");
        desc.addFamily(colDesc);
        admin.createTable(desc);
        Assert.assertEquals((long)0L, (long)admin.listTables().length);
        Assert.assertTrue((boolean)admin.tableExists(Bytes.toBytes((String)tableName)));
        admin.disableTable(desc.getTableName());
        admin.deleteTable(desc.getTableName());
    }

    @Ignore
    @Test
    public void testNamespaceJanitor() throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        int fsCount = fs.listStatus(new Path(FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), "data")).length;
        Path fakeNSPath = FSUtils.getNamespaceDir((Path)FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), (String)"foo");
        Assert.assertTrue((boolean)fs.mkdirs(fakeNSPath));
        String fakeZnode = ZKUtil.joinZNode((String)ZooKeeperWatcher.namespaceZNode, (String)"foo");
        int zkCount = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)ZooKeeperWatcher.namespaceZNode).size();
        ZKUtil.createWithParents((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)fakeZnode);
        Thread.sleep(10000L);
        Assert.assertFalse((boolean)fs.exists(fakeNSPath));
        Assert.assertEquals((long)fsCount, (long)fs.listStatus(new Path(FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), "data")).length);
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)fakeZnode));
        Assert.assertEquals((long)zkCount, (long)ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)ZooKeeperWatcher.namespaceZNode).size());
    }

    @Test(timeout=60000L)
    public void testNamespaceOperations() throws IOException {
        admin.createNamespace(NamespaceDescriptor.create((String)(this.prefix + "ns1")).build());
        admin.createNamespace(NamespaceDescriptor.create((String)(this.prefix + "ns2")).build());
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.createNamespace(NamespaceDescriptor.create((String)(TestNamespace.this.prefix + "ns1")).build());
                return null;
            }
        }, NamespaceExistException.class);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"non_existing_namespace", (String)"table1"));
                htd.addFamily(new HColumnDescriptor("family1"));
                admin.createTable(htd);
                return null;
            }
        }, NamespaceNotFoundException.class);
        admin.getNamespaceDescriptor(this.prefix + "ns1");
        TestNamespace.runWithExpectedException(new Callable<NamespaceDescriptor>(){

            @Override
            public NamespaceDescriptor call() throws Exception {
                return admin.getNamespaceDescriptor("non_existing_namespace");
            }
        }, NamespaceNotFoundException.class);
        admin.deleteNamespace(this.prefix + "ns2");
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.deleteNamespace("non_existing_namespace");
                return null;
            }
        }, NamespaceNotFoundException.class);
        NamespaceDescriptor ns1 = admin.getNamespaceDescriptor(this.prefix + "ns1");
        ns1.setConfiguration("foo", "bar");
        admin.modifyNamespace(ns1);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.modifyNamespace(NamespaceDescriptor.create((String)"non_existing_namespace").build());
                return null;
            }
        }, NamespaceNotFoundException.class);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)(this.prefix + "ns1"), (String)"table1"));
        htd.addFamily(new HColumnDescriptor("family1"));
        admin.createTable(htd);
        HTableDescriptor[] htds = admin.listTableDescriptorsByNamespace(this.prefix + "ns1");
        Assert.assertNotNull((String)"Should have not returned null", (Object)htds);
        Assert.assertEquals((String)"Should have returned non-empty array", (long)1L, (long)htds.length);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.listTableDescriptorsByNamespace("non_existing_namespace");
                return null;
            }
        }, NamespaceNotFoundException.class);
        TableName[] tableNames = admin.listTableNamesByNamespace(this.prefix + "ns1");
        Assert.assertNotNull((String)"Should have not returned null", (Object)tableNames);
        Assert.assertEquals((String)"Should have returned non-empty array", (long)1L, (long)tableNames.length);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.listTableNamesByNamespace("non_existing_namespace");
                return null;
            }
        }, NamespaceNotFoundException.class);
    }

    private static <V, E> void runWithExpectedException(Callable<V> callable, Class<E> exceptionClass) {
        try {
            callable.call();
        }
        catch (Exception ex) {
            Assert.assertEquals(exceptionClass, ex.getClass());
            return;
        }
        Assert.fail((String)("Should have thrown exception " + exceptionClass));
    }
}

