/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class Threads {
    protected static final Log LOG = LogFactory.getLog(Threads.class);
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private static Method printThreadInfoMethod = null;
    private static boolean printThreadInfoMethodWithPrintStream = true;

    public static Thread setDaemonThreadRunning(Thread t) {
        return Threads.setDaemonThreadRunning(t, t.getName());
    }

    public static Thread setDaemonThreadRunning(Thread t, String name) {
        return Threads.setDaemonThreadRunning(t, name, null);
    }

    public static Thread setDaemonThreadRunning(Thread t, String name, Thread.UncaughtExceptionHandler handler) {
        t.setName(name);
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        }
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static void shutdown(Thread t) {
        Threads.shutdown(t, 0L);
    }

    public static void shutdown(Thread t, long joinwait) {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            try {
                t.join(joinwait);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)(t.getName() + "; joinwait=" + joinwait), (Throwable)e);
            }
        }
    }

    public static void threadDumpingIsAlive(Thread t) throws InterruptedException {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            t.join(60000L);
            if (!t.isAlive()) continue;
            Threads.printThreadInfo(System.out, "Automatic Stack Trace every 60 seconds waiting on " + t.getName());
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public static void sleepWithoutInterrupt(long msToWait) {
        long timeMillis = System.currentTimeMillis();
        long endTime = timeMillis + msToWait;
        boolean interrupted = false;
        while (timeMillis < endTime) {
            try {
                Thread.sleep(endTime - timeMillis);
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
            timeMillis = System.currentTimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadPoolExecutor getBoundedCachedThreadPool(int maxCachedThread, long timeout, TimeUnit unit, ThreadFactory threadFactory) {
        ThreadPoolExecutor boundedCachedThreadPool = new ThreadPoolExecutor(maxCachedThread, maxCachedThread, timeout, unit, new LinkedBlockingQueue<Runnable>(), threadFactory);
        boundedCachedThreadPool.allowCoreThreadTimeOut(true);
        return boundedCachedThreadPool;
    }

    public static ThreadFactory getNamedThreadFactory(final String prefix) {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);
            private final int poolNumber = Threads.access$000().getAndIncrement();
            final ThreadGroup group = threadGroup;

            @Override
            public Thread newThread(Runnable r) {
                String name = prefix + "-pool" + this.poolNumber + "-t" + this.threadNumber.getAndIncrement();
                return new Thread(this.group, r, name);
            }
        };
    }

    public static ThreadFactory newDaemonThreadFactory(String prefix) {
        return Threads.newDaemonThreadFactory(prefix, null);
    }

    public static ThreadFactory newDaemonThreadFactory(String prefix, final Thread.UncaughtExceptionHandler handler) {
        final ThreadFactory namedFactory = Threads.getNamedThreadFactory(prefix);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = namedFactory.newThread(r);
                if (handler != null) {
                    t.setUncaughtExceptionHandler(handler);
                }
                if (!t.isDaemon()) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    public static void printThreadInfo(PrintStream stream, String title) {
        if (printThreadInfoMethod == null) {
            try {
                printThreadInfoMethod = ReflectionUtils.class.getMethod("printThreadInfo", PrintStream.class, String.class);
            }
            catch (NoSuchMethodException e) {
                printThreadInfoMethodWithPrintStream = false;
                try {
                    printThreadInfoMethod = ReflectionUtils.class.getMethod("printThreadInfo", PrintWriter.class, String.class);
                }
                catch (NoSuchMethodException e1) {
                    throw new RuntimeException("Cannot find method. Check hadoop jars linked", e1);
                }
            }
            printThreadInfoMethod.setAccessible(true);
        }
        try {
            if (printThreadInfoMethodWithPrintStream) {
                printThreadInfoMethod.invoke(null, stream, title);
            } else {
                printThreadInfoMethod.invoke(null, new PrintWriter(stream), title);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    static /* synthetic */ AtomicInteger access$000() {
        return poolNumber;
    }
}

