/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSTestWrapper;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;

public final class FileSystemTestWrapper
extends FSTestWrapper {
    private final FileSystem fs;

    public FileSystemTestWrapper(FileSystem fs) {
        this(fs, null);
    }

    public FileSystemTestWrapper(FileSystem fs, String rootDir) {
        super(rootDir);
        this.fs = fs;
    }

    @Override
    public FSTestWrapper getLocalFSWrapper() throws IOException {
        return new FileSystemTestWrapper((FileSystem)FileSystem.getLocal((Configuration)this.fs.getConf()));
    }

    @Override
    public Path getDefaultWorkingDirectory() throws IOException {
        return this.getTestRootPath("/user/" + System.getProperty("user.name")).makeQualified(this.fs.getUri(), this.fs.getWorkingDirectory());
    }

    @Override
    public long createFile(Path path, int numBlocks, Options.CreateOpts ... options) throws IOException {
        Options.CreateOpts.BlockSize blockSizeOpt = (Options.CreateOpts.BlockSize)Options.CreateOpts.getOpt(Options.CreateOpts.BlockSize.class, (Options.CreateOpts[])options);
        long blockSize = blockSizeOpt != null ? blockSizeOpt.getValue() : 1024L;
        FSDataOutputStream out = this.create(path, EnumSet.of(CreateFlag.CREATE), options);
        byte[] data = FileSystemTestWrapper.getFileData(numBlocks, blockSize);
        out.write(data, 0, data.length);
        out.close();
        return data.length;
    }

    @Override
    public long createFile(Path path, int numBlocks, int blockSize) throws IOException {
        return this.createFile(path, numBlocks, new Options.CreateOpts[]{Options.CreateOpts.blockSize((long)blockSize), Options.CreateOpts.createParent()});
    }

    @Override
    public long createFile(Path path) throws IOException {
        return this.createFile(path, 2, new Options.CreateOpts[]{Options.CreateOpts.createParent()});
    }

    @Override
    public long createFile(String name) throws IOException {
        Path path = this.getTestRootPath(name);
        return this.createFile(path);
    }

    @Override
    public long createFileNonRecursive(String name) throws IOException {
        Path path = this.getTestRootPath(name);
        return this.createFileNonRecursive(path);
    }

    @Override
    public long createFileNonRecursive(Path path) throws IOException {
        return this.createFile(path, 2, new Options.CreateOpts[]{Options.CreateOpts.donotCreateParent()});
    }

    @Override
    public void appendToFile(Path path, int numBlocks, Options.CreateOpts ... options) throws IOException {
        Options.CreateOpts.BlockSize blockSizeOpt = (Options.CreateOpts.BlockSize)Options.CreateOpts.getOpt(Options.CreateOpts.BlockSize.class, (Options.CreateOpts[])options);
        long blockSize = blockSizeOpt != null ? blockSizeOpt.getValue() : 1024L;
        FSDataOutputStream out = this.fs.append(path);
        byte[] data = FileSystemTestWrapper.getFileData(numBlocks, blockSize);
        out.write(data, 0, data.length);
        out.close();
    }

    @Override
    public boolean exists(Path p) throws IOException {
        return this.fs.exists(p);
    }

    @Override
    public boolean isFile(Path p) throws IOException {
        try {
            return this.fs.getFileStatus(p).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isDir(Path p) throws IOException {
        try {
            return this.fs.getFileStatus(p).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isSymlink(Path p) throws IOException {
        try {
            return this.fs.getFileLinkStatus(p).isSymlink();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public void writeFile(Path path, byte[] b) throws IOException {
        FSDataOutputStream out = this.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        out.write(b);
        out.close();
    }

    @Override
    public byte[] readFile(Path path, int len) throws IOException {
        FSDataInputStream dis = this.fs.open(path);
        byte[] buffer = new byte[len];
        IOUtils.readFully((InputStream)dis, (byte[])buffer, (int)0, (int)len);
        dis.close();
        return buffer;
    }

    @Override
    public FileStatus containsPath(Path path, FileStatus[] dirList) throws IOException {
        for (int i = 0; i < dirList.length; ++i) {
            if (!path.equals((Object)dirList[i].getPath())) continue;
            return dirList[i];
        }
        return null;
    }

    @Override
    public FileStatus containsPath(String path, FileStatus[] dirList) throws IOException {
        return this.containsPath(new Path(path), dirList);
    }

    @Override
    public void checkFileStatus(String path, FSTestWrapper.fileType expectedType) throws IOException {
        FileStatus s = this.fs.getFileStatus(new Path(path));
        Assert.assertNotNull((Object)s);
        if (expectedType == FSTestWrapper.fileType.isDir) {
            Assert.assertTrue((boolean)s.isDirectory());
        } else if (expectedType == FSTestWrapper.fileType.isFile) {
            Assert.assertTrue((boolean)s.isFile());
        } else if (expectedType == FSTestWrapper.fileType.isSymlink) {
            Assert.assertTrue((boolean)s.isSymlink());
        }
        Assert.assertEquals((Object)this.fs.makeQualified(new Path(path)), (Object)s.getPath());
    }

    @Override
    public void checkFileLinkStatus(String path, FSTestWrapper.fileType expectedType) throws IOException {
        FileStatus s = this.fs.getFileLinkStatus(new Path(path));
        Assert.assertNotNull((Object)s);
        if (expectedType == FSTestWrapper.fileType.isDir) {
            Assert.assertTrue((boolean)s.isDirectory());
        } else if (expectedType == FSTestWrapper.fileType.isFile) {
            Assert.assertTrue((boolean)s.isFile());
        } else if (expectedType == FSTestWrapper.fileType.isSymlink) {
            Assert.assertTrue((boolean)s.isSymlink());
        }
        Assert.assertEquals((Object)this.fs.makeQualified(new Path(path)), (Object)s.getPath());
    }

    @Override
    public Path makeQualified(Path path) {
        return this.fs.makeQualified(path);
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.fs.mkdirs(dir, permission);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fs.delete(f, recursive);
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fs.getFileLinkStatus(f);
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.fs.createSymlink(target, link, createParent);
    }

    @Override
    public void setWorkingDirectory(Path newWDir) throws IOException {
        this.fs.setWorkingDirectory(newWDir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.fs.getWorkingDirectory();
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fs.getFileStatus(f);
    }

    @Override
    public FSDataOutputStream create(Path f, EnumSet<CreateFlag> createFlag, Options.CreateOpts ... opts) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        Options.CreateOpts.Perms permOpt = (Options.CreateOpts.Perms)Options.CreateOpts.getOpt(Options.CreateOpts.Perms.class, (Options.CreateOpts[])opts);
        FsPermission umask = FsPermission.getUMask((Configuration)this.fs.getConf());
        FsPermission permission = permOpt != null ? permOpt.getValue() : FsPermission.getFileDefault().applyUMask(umask);
        permission = permission.applyUMask(umask);
        boolean overwrite = createFlag.contains(CreateFlag.OVERWRITE);
        int bufferSize = this.fs.getConf().getInt("io.file.buffer.size", 4096);
        Options.CreateOpts.BufferSize bufOpt = (Options.CreateOpts.BufferSize)Options.CreateOpts.getOpt(Options.CreateOpts.BufferSize.class, (Options.CreateOpts[])opts);
        bufferSize = bufOpt != null ? bufOpt.getValue() : bufferSize;
        short replication = this.fs.getDefaultReplication(f);
        Options.CreateOpts.ReplicationFactor repOpt = (Options.CreateOpts.ReplicationFactor)Options.CreateOpts.getOpt(Options.CreateOpts.ReplicationFactor.class, (Options.CreateOpts[])opts);
        replication = repOpt != null ? repOpt.getValue() : replication;
        long blockSize = this.fs.getDefaultBlockSize(f);
        Options.CreateOpts.BlockSize blockOpt = (Options.CreateOpts.BlockSize)Options.CreateOpts.getOpt(Options.CreateOpts.BlockSize.class, (Options.CreateOpts[])opts);
        blockSize = blockOpt != null ? blockOpt.getValue() : blockSize;
        Progressable progress = null;
        Options.CreateOpts.Progress progressOpt = (Options.CreateOpts.Progress)Options.CreateOpts.getOpt(Options.CreateOpts.Progress.class, (Options.CreateOpts[])opts);
        progress = progressOpt != null ? progressOpt.getValue() : progress;
        return this.fs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataInputStream open(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fs.open(f);
    }

    @Override
    public Path getLinkTarget(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fs.getLinkTarget(f);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, IOException {
        return this.fs.setReplication(f, replication);
    }

    @Override
    public void rename(Path src, Path dst, Options.Rename ... options) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.fs.rename(src, dst, options);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fs.getFileBlockLocations(f, start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        return this.fs.getFileChecksum(f);
    }

    @Override
    public RemoteIterator<FileStatus> listStatusIterator(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        FileStatus[] statuses = this.fs.listStatus(f);
        return new FakeRemoteIterator<FileStatus>(statuses);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.fs.setPermission(f, permission);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, UnsupportedFileSystemException, FileNotFoundException, IOException {
        this.fs.setOwner(f, username, groupname);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.fs.setTimes(f, mtime, atime);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fs.listStatus(f);
    }

    private class FakeRemoteIterator<E>
    implements RemoteIterator<E> {
        private E[] elements;
        private int count;

        FakeRemoteIterator(E[] elements) {
            this.elements = elements;
            this.count = 0;
        }

        public boolean hasNext() throws IOException {
            return this.count < this.elements.length;
        }

        public E next() throws IOException {
            if (this.hasNext()) {
                return this.elements[this.count++];
            }
            return null;
        }
    }
}

