/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class MulticastTool {
    private static final int BUFF_SIZE = 8192;

    public static void main(String[] array) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        String send = null;
        long rate = 1000L;
        String host = "239.255.3.2";
        int port = 6142;
        Integer ttl = null;
        Boolean loopbackmode = null;
        Integer socketTimeout = null;
        Iterator<String> args = Arrays.asList(array).iterator();
        while (args.hasNext()) {
            String arg = args.next();
            if (arg.equals("--host") || arg.equals("-h")) {
                host = args.next();
                continue;
            }
            if (arg.equals("--port") || arg.equals("-p")) {
                port = Integer.parseInt(args.next());
                continue;
            }
            if (arg.equals("--rate") || arg.equals("-r")) {
                rate = new Long(args.next());
                continue;
            }
            if (arg.equals("--ttl")) {
                ttl = new Integer(args.next());
                continue;
            }
            if (arg.equals("--send") || arg.equals("-s")) {
                send = args.next();
                continue;
            }
            if (arg.equals("--timeout") || arg.equals("-t")) {
                socketTimeout = new Integer(args.next());
                continue;
            }
            if (arg.equals("--loopback") || arg.equals("-l")) {
                loopbackmode = new Boolean(args.next());
                continue;
            }
            throw new IllegalArgumentException(arg);
        }
        InetAddress inetAddress = InetAddress.getByName(host);
        InetSocketAddress address = new InetSocketAddress(inetAddress, port);
        MulticastSocket multicast = new MulticastSocket(port);
        multicast.joinGroup(inetAddress);
        if (ttl != null) {
            multicast.setTimeToLive(ttl);
        }
        if (socketTimeout != null) {
            multicast.setSoTimeout(socketTimeout);
        }
        if (loopbackmode != null) {
            multicast.setLoopbackMode(loopbackmode);
        }
        System.out.print("Connecting to multicast group: ");
        System.out.print(host);
        System.out.print(":");
        System.out.println(multicast.getLocalPort());
        MulticastTool.print("LoopbackMode", multicast.getLoopbackMode());
        MulticastTool.print("TimeToLive", multicast.getTimeToLive());
        MulticastTool.print("SoTimeout", multicast.getSoTimeout());
        System.out.println("-------------------------------");
        if (send != null) {
            Timer timer = new Timer("Multicast Send", true);
            timer.scheduleAtFixedRate((TimerTask)new Send(address, multicast, send), 0L, rate);
        }
        byte[] buf = new byte[8192];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        while (true) {
            try {
                while (true) {
                    multicast.receive(packet);
                    if (packet.getLength() <= 0) continue;
                    InetAddress a = packet.getAddress();
                    System.out.print(format.format(new Date()));
                    System.out.print(" - ");
                    System.out.print(a.getHostAddress());
                    System.out.print(" - ");
                    String str = new String(packet.getData(), packet.getOffset(), packet.getLength());
                    System.out.println(str);
                }
            }
            catch (SocketTimeoutException e) {
                continue;
            }
            break;
        }
    }

    private static void print(String name, Object value) {
        System.out.print(name);
        System.out.print(":");
        System.out.println(value);
    }

    static class Send
    extends TimerTask {
        private final MulticastSocket multicast;
        private final String text;
        private final SocketAddress address;

        public Send(SocketAddress address, MulticastSocket multicast, String text) {
            this.address = address;
            this.multicast = multicast;
            this.text = text;
        }

        public void run() {
            try {
                byte[] data = this.text.getBytes();
                DatagramPacket packet = new DatagramPacket(data, 0, data.length, this.address);
                this.multicast.send(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

