/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.EJBObjectProxy;
import org.apache.openejb.client.ServerMetaData;

public class EJBObjectHandle
implements Externalizable,
Handle {
    protected transient EJBObjectProxy ejbObjectProxy;
    protected transient EJBObjectHandler handler;

    public EJBObjectHandle() {
    }

    public EJBObjectHandle(EJBObjectProxy proxy) {
        this.ejbObjectProxy = proxy;
        this.handler = this.ejbObjectProxy.getEJBObjectHandler();
    }

    protected void setEJBObjectProxy(EJBObjectProxy ejbObjectProxy) {
        this.ejbObjectProxy = ejbObjectProxy;
        this.handler = ejbObjectProxy.getEJBObjectHandler();
    }

    public EJBObject getEJBObject() throws RemoteException {
        return (EJBObject)this.ejbObjectProxy;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        this.handler.client.writeExternal(out);
        EJBMetaDataImpl ejb = this.handler.ejb;
        out.writeObject(EJBObjectHandle.getClassName(ejb.homeClass));
        out.writeObject(EJBObjectHandle.getClassName(ejb.remoteClass));
        out.writeObject(EJBObjectHandle.getClassName(ejb.keyClass));
        out.writeByte(ejb.type);
        out.writeUTF(ejb.deploymentID);
        out.writeShort(ejb.deploymentCode);
        this.handler.server.writeExternal(out);
        out.writeObject(this.handler.primaryKey);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        ClientMetaData client = new ClientMetaData();
        EJBMetaDataImpl ejb = new EJBMetaDataImpl();
        ServerMetaData server = new ServerMetaData();
        client.readExternal(in);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ejb.homeClass = EJBObjectHandle.loadClass(classLoader, (String)in.readObject());
        ejb.remoteClass = EJBObjectHandle.loadClass(classLoader, (String)in.readObject());
        ejb.keyClass = EJBObjectHandle.loadClass(classLoader, (String)in.readObject());
        ejb.type = in.readByte();
        ejb.deploymentID = in.readUTF();
        ejb.deploymentCode = in.readShort();
        server.readExternal(in);
        Object primaryKey = in.readObject();
        this.handler = EJBObjectHandler.createEJBObjectHandler(ejb, server, client, primaryKey);
        this.ejbObjectProxy = this.handler.createEJBObjectProxy();
    }

    private static String getClassName(Class clazz) {
        return clazz == null ? null : clazz.getName();
    }

    private static Class loadClass(ClassLoader classLoader, String homeClassName) throws ClassNotFoundException {
        return homeClassName == null ? null : Class.forName(homeClassName, true, classLoader);
    }
}

