/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;

public class RegexSyntaxChecker
extends AbstractSyntaxChecker {
    private List<String> expressions;

    public RegexSyntaxChecker(String oid, String[] matchExprArray) {
        super(oid);
        if (matchExprArray != null && matchExprArray.length != 0) {
            this.expressions = new ArrayList<String>(matchExprArray.length);
            for (String regexp : matchExprArray) {
                this.expressions.add(regexp);
            }
        } else {
            this.expressions = new ArrayList<String>();
        }
    }

    protected RegexSyntaxChecker(String oid) {
        super(oid);
        this.expressions = new ArrayList<String>();
    }

    public boolean isValidSyntax(Object value) {
        String str = null;
        boolean match = true;
        if (value instanceof String) {
            str = (String)value;
            for (String regexp : this.expressions) {
                if (match = match && str.matches(regexp)) continue;
                break;
            }
        }
        return match;
    }

    public String[] getExpressions() {
        String[] exprs = new String[this.expressions.size()];
        return this.expressions.toArray(exprs);
    }

    public void setExpressions(String[] expressions) {
        for (String regexp : expressions) {
            this.expressions.add(regexp);
        }
    }
}

