/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.stateful.DecoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.DecoderMonitor;
import org.apache.directory.shared.asn1.codec.stateful.StatefulDecoder;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.MessageException;
import org.apache.directory.shared.ldap.message.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.message.spi.Provider;
import org.apache.directory.shared.ldap.message.spi.ProviderDecoder;
import org.apache.directory.shared.ldap.message.spi.TransformerSpi;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageDecoder
implements ProviderDecoder {
    private static final Logger log = LoggerFactory.getLogger(MessageDecoder.class);
    private static final String BINARY_KEY = "java.naming.ldap.attributes.binary";
    private final Hashtable env;
    private final Provider provider;
    private final ProviderDecoder decoder;
    private final TransformerSpi transformer;
    private DecoderCallback cb;

    public MessageDecoder(Hashtable env) throws MessageException {
        Set<String> binaries;
        this.env = (Hashtable)env.clone();
        Properties providerEnv = Provider.getEnvironment();
        this.env.put("asn.1.berlib.provider", ((Hashtable)providerEnv).get("asn.1.berlib.provider"));
        this.provider = Provider.getProvider(providerEnv);
        if (env.containsKey(BINARY_KEY)) {
            Object val = env.get(BINARY_KEY);
            if (val == null) {
                if (log.isWarnEnabled()) {
                    log.warn("Null value for java.naming.ldap.attributes.binary key in environment.  Using empty set for binaries.");
                }
                binaries = Collections.EMPTY_SET;
            } else if (val instanceof String) {
                String binaryIds = (String)val;
                binaries = new HashSet();
                if (!StringTools.isEmpty(binaryIds)) {
                    String[] binaryArray;
                    for (String binary : binaryArray = binaryIds.split(" ")) {
                        binaries.add(StringTools.lowerCaseAscii(StringTools.trim(binary)));
                    }
                }
            } else if (val instanceof Collection) {
                binaries = new HashSet();
                binaries.addAll((Set)val);
            } else {
                if (log.isWarnEnabled()) {
                    log.warn("Unrecognized value for java.naming.ldap.attributes.binary key in environment.  Using empty set for binaries.");
                }
                binaries = Collections.EMPTY_SET;
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn("Could not find java.naming.ldap.attributes.binary key in environment.  Using empty set for binaries.");
            }
            binaries = Collections.EMPTY_SET;
        }
        this.decoder = this.provider.getDecoder(binaries);
        this.transformer = this.provider.getTransformer();
        this.decoder.setCallback(new DecoderCallback(){

            public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
                if (decoded instanceof Asn1Object) {
                    MessageDecoder.this.cb.decodeOccurred(decoder, (Object)MessageDecoder.this.transformer.transform(decoded));
                } else {
                    MessageDecoder.this.cb.decodeOccurred(decoder, decoded);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object lock, InputStream in) throws MessageException {
        Object providerEnvelope;
        block6: {
            try {
                if (lock == null) {
                    providerEnvelope = this.decoder.decode(lock, in);
                    break block6;
                }
                Object object = lock;
                synchronized (object) {
                    providerEnvelope = this.decoder.decode(lock, in);
                    lock.notifyAll();
                }
            }
            catch (Exception e) {
                throw (MessageException)e;
            }
        }
        Message message = this.transformer.transform(providerEnvelope);
        return message;
    }

    public void decode(Object chunk) throws MessageException {
        try {
            this.decoder.decode(chunk);
        }
        catch (DecoderException e) {
            if (e instanceof ResponseCarryingException) {
                ResponseCarryingMessageException rcme = new ResponseCarryingMessageException(e.getMessage());
                rcme.setResponse(((ResponseCarryingException)e).getResponse());
                throw rcme;
            }
            throw new ResponseCarryingMessageException(e.getMessage());
        }
    }

    public void setCallback(DecoderCallback cb) {
        this.cb = cb;
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
        this.decoder.setDecoderMonitor(monitor);
    }

    public Provider getProvider() {
        return this.provider;
    }
}

