/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.io.IOException;
import java.text.ParseException;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.filter.FilterVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchNormalizedVisitor
implements FilterVisitor {
    @Override
    public void visit(ExprNode node) {
        if (!(node instanceof BranchNode)) {
            return;
        }
        BranchNode branch = (BranchNode)node;
        if (branch.getOperator() == AssertionEnum.NOT) {
            return;
        }
        NodeComparator nodeComparator = new NodeComparator();
        TreeSet<ExprNode> set = new TreeSet<ExprNode>(nodeComparator);
        List<ExprNode> children = branch.getChildren();
        for (ExprNode child : branch.getChildren()) {
            if (!child.isLeaf()) {
                this.visit(child);
            }
            set.add(child);
        }
        children.clear();
        children.addAll(set);
    }

    @Override
    public boolean canVisit(ExprNode node) {
        return node instanceof BranchNode;
    }

    @Override
    public boolean isPrefix() {
        return false;
    }

    @Override
    public List<ExprNode> getOrder(BranchNode node, List<ExprNode> children) {
        return children;
    }

    public static String getNormalizedFilter(String filter) throws IOException, ParseException {
        FilterParserImpl parser = new FilterParserImpl();
        ExprNode originalNode = parser.parse(filter);
        return BranchNormalizedVisitor.getNormalizedFilter(originalNode);
    }

    public static String getNormalizedFilter(ExprNode filter) {
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        visitor.visit(filter);
        StringBuffer normalized = new StringBuffer();
        filter.printToBuffer(normalized);
        return normalized.toString().trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeComparator
    implements Comparator<ExprNode> {
        NodeComparator() {
        }

        @Override
        public int compare(ExprNode o1, ExprNode o2) {
            StringBuffer buf = new StringBuffer();
            buf.setLength(0);
            String s1 = null;
            o1.printToBuffer(buf);
            s1 = buf.toString();
            buf.setLength(0);
            String s2 = null;
            o2.printToBuffer(buf);
            s2 = buf.toString();
            return s1.compareTo(s2);
        }
    }
}

