/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchNode
extends AbstractExprNode {
    private final AssertionEnum operator;
    private List<ExprNode> children = null;

    public BranchNode(AssertionEnum operator, List<ExprNode> childList) {
        super(operator);
        this.children = null == childList ? new ArrayList<ExprNode>(2) : childList;
        this.operator = operator;
        switch (operator) {
            case AND: 
            case NOT: 
            case OR: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Logical operator argument in constructor is undefined.");
            }
        }
    }

    public BranchNode(AssertionEnum operator) {
        this(operator, null);
    }

    public void addNode(ExprNode node) {
        if (AssertionEnum.NOT == this.operator && this.children.size() >= 1) {
            throw new IllegalStateException("Cannot add more than one element to a negation node.");
        }
        this.children.add(node);
    }

    public void addNodeToHead(ExprNode node) {
        if (AssertionEnum.NOT == this.operator && this.children.size() >= 1) {
            throw new IllegalStateException("Cannot add more than one element to a negation node.");
        }
        this.children.add(0, node);
    }

    @Override
    public final boolean isLeaf() {
        return false;
    }

    public List<ExprNode> getChildren() {
        return this.children;
    }

    public ExprNode getChild() {
        if (this.children.size() > 0) {
            return this.children.get(0);
        }
        return null;
    }

    void setChildren(List<ExprNode> list) {
        this.children = list;
    }

    public AssertionEnum getOperator() {
        return this.operator;
    }

    public boolean isDisjunction() {
        return AssertionEnum.OR == this.operator;
    }

    public boolean isConjunction() {
        return AssertionEnum.AND == this.operator;
    }

    public boolean isNegation() {
        return AssertionEnum.NOT == this.operator;
    }

    @Override
    public StringBuffer printToBuffer(StringBuffer buf) {
        buf.append('(');
        switch (this.operator) {
            case AND: {
                buf.append("& ");
                break;
            }
            case NOT: {
                buf.append("! ");
                break;
            }
            case OR: {
                buf.append("| ");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        for (ExprNode node : this.children) {
            node.printToBuffer(buf);
        }
        buf.append(')');
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            buf.append('[');
            buf.append(((Long)this.getAnnotations().get("count")).toString());
            buf.append("] ");
        } else {
            buf.append(' ');
        }
        return buf;
    }

    @Override
    public StringBuffer printRefinementToBuffer(StringBuffer buf) throws UnsupportedOperationException {
        switch (this.operator) {
            case AND: {
                buf.append("and");
                break;
            }
            case OR: {
                buf.append("or");
                break;
            }
            case NOT: {
                buf.append("not");
            }
        }
        buf.append(':');
        buf.append(' ');
        buf.append('{');
        Iterator<ExprNode> it = this.children.iterator();
        while (it.hasNext()) {
            ExprNode node = it.next();
            node.printRefinementToBuffer(buf);
            if (!it.hasNext()) continue;
            buf.append(',');
            buf.append(' ');
        }
        buf.append('}');
        return buf;
    }

    public static String getOperatorString(AssertionEnum operator) {
        String opstr = null;
        switch (operator) {
            case AND: {
                opstr = "AND";
                break;
            }
            case NOT: {
                opstr = "NOT";
                break;
            }
            case OR: {
                opstr = "OR";
                break;
            }
            default: {
                opstr = "UNKNOWN";
            }
        }
        return opstr;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(BranchNode.getOperatorString(this.operator));
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            buf.append('[');
            buf.append(((Long)this.getAnnotations().get("count")).toString());
            buf.append("] ");
        } else {
            buf.append(' ');
        }
        return buf.toString();
    }

    @Override
    public void accept(FilterVisitor visitor) {
        if (visitor.isPrefix()) {
            List<ExprNode> children = visitor.getOrder(this, this.children);
            if (visitor.canVisit(this)) {
                visitor.visit(this);
            }
            for (ExprNode node : children) {
                node.accept(visitor);
            }
        } else {
            List<ExprNode> children = visitor.getOrder(this, this.children);
            for (ExprNode node : children) {
                node.accept(visitor);
            }
            if (visitor.canVisit(this)) {
                visitor.visit(this);
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof BranchNode)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        BranchNode otherExprNode = (BranchNode)other;
        List<ExprNode> otherChildren = otherExprNode.getChildren();
        if (otherExprNode.getOperator() != this.operator) {
            return false;
        }
        if (otherChildren == this.children) {
            return true;
        }
        return null != this.children && null != otherChildren && ((Object)this.children).equals(otherChildren);
    }
}

