/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequest;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyAttributeValueAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ModifyAttributeValueAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ModifyAttributeValueAction() {
        super("Stores AttributeValue");
    }

    public void action(IAsn1Container container) {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        byte[] value = StringTools.EMPTY_BYTES;
        if (tlv.getLength() == 0) {
            modifyRequest.addAttributeValue("");
        } else {
            value = tlv.getValue().getData();
            if (ldapMessageContainer.isBinary(modifyRequest.getCurrentAttributeType())) {
                modifyRequest.addAttributeValue(value);
            } else {
                modifyRequest.addAttributeValue(StringTools.utf8ToString(value));
            }
        }
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            log.debug("Value modified : {}", (Object)value);
        }
    }
}

