/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.asn1.ber.AbstractContainer;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.ldap.codec.Control;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageGrammar;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;

public class LdapMessageContainer
extends AbstractContainer
implements IAsn1Container {
    private LdapMessage ldapMessage;
    private Set binaries;
    private int messageId;
    private Control currentControl;

    public LdapMessageContainer() {
        this(new HashSet());
    }

    public LdapMessageContainer(Set binaries) {
        this.stateStack = new int[10];
        this.grammar = LdapMessageGrammar.getInstance();
        this.states = LdapStatesEnum.getInstance();
        this.binaries = binaries;
    }

    public LdapMessage getLdapMessage() {
        return this.ldapMessage;
    }

    public void setLdapMessage(LdapMessage ldapMessage) {
        this.ldapMessage = ldapMessage;
    }

    public void clean() {
        super.clean();
        this.ldapMessage = null;
        this.messageId = 0;
        this.currentControl = null;
    }

    public boolean isBinary(String id) {
        return this.binaries.contains(StringTools.lowerCaseAscii(StringTools.trim(id)));
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public Control getCurrentControl() {
        return this.currentControl;
    }

    public void setCurrentControl(Control currentControl) {
        this.currentControl = currentControl;
    }
}

