/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.Comparator;

public class ByteArrayComparator
implements Comparator {
    public static final ByteArrayComparator INSTANCE = new ByteArrayComparator();

    public int compare(Object byteArray1, Object byteArray2) {
        byte[] b1 = (byte[])byteArray1;
        byte[] b2 = (byte[])byteArray2;
        if (b1 == null && b2 == null) {
            return 0;
        }
        if (b1 != null && b2 == null) {
            return 1;
        }
        if (b1 == null && b2 != null) {
            return -1;
        }
        if (b1.length == b2.length) {
            for (int ii = 0; ii < b1.length; ++ii) {
                if (b1[ii] > b2[ii]) {
                    return 1;
                }
                if (b1[ii] >= b2[ii]) continue;
                return -1;
            }
            return 0;
        }
        int minLength = Math.min(b1.length, b2.length);
        for (int ii = 0; ii < minLength; ++ii) {
            if (b1[ii] > b2[ii]) {
                return 1;
            }
            if (b1[ii] >= b2[ii]) continue;
            return -1;
        }
        if (b1.length == minLength) {
            return -1;
        }
        if (b2.length == minLength) {
            return 1;
        }
        return 0;
    }
}

