/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.directory.Attribute;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.ModifyResponse;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.name.LdapDN;

public class ModifyRequestImpl
extends AbstractAbandonableRequest
implements ModifyRequest {
    static final long serialVersionUID = -505803669028990304L;
    private LdapDN name;
    private ArrayList mods = new ArrayList();
    private ModifyResponse response;

    public ModifyRequestImpl(int id) {
        super(id, TYPE);
    }

    public Collection getModificationItems() {
        return Collections.unmodifiableCollection(this.mods);
    }

    public LdapDN getName() {
        return this.name;
    }

    public void setName(LdapDN name) {
        this.name = name;
    }

    public void addModification(ModificationItemImpl mod) {
        this.mods.add(mod);
    }

    public void removeModification(ModificationItemImpl mod) {
        this.mods.remove(mod);
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ModifyResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifyRequest req = (ModifyRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (req.getModificationItems().size() != this.mods.size()) {
            return false;
        }
        Iterator list = req.getModificationItems().iterator();
        for (int ii = 0; ii < this.mods.size(); ++ii) {
            ModificationItemImpl item = (ModificationItemImpl)list.next();
            if (this.equals((ModificationItemImpl)this.mods.get(ii), item)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(ModificationItemImpl item0, ModificationItemImpl item1) {
        if (item0 == item1) {
            return true;
        }
        if (item0.getModificationOp() != item1.getModificationOp()) {
            return false;
        }
        if (!item0.getAttribute().getID().equals(item1.getAttribute().getID())) {
            return false;
        }
        Attribute attr0 = item0.getAttribute();
        Attribute attr1 = item1.getAttribute();
        return attr0.equals(attr1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Modify Request\n");
        sb.append("        Object : '").append(this.name).append("'\n");
        if (this.mods != null) {
            for (int i = 0; i < this.mods.size(); ++i) {
                ModificationItemImpl modification = (ModificationItemImpl)this.mods.get(i);
                sb.append("            Modification[").append(i).append("]\n");
                sb.append("                Operation : ");
                switch (modification.getModificationOp()) {
                    case 1: {
                        sb.append(" add\n");
                        break;
                    }
                    case 2: {
                        sb.append(" replace\n");
                        break;
                    }
                    case 3: {
                        sb.append(" delete\n");
                    }
                }
                sb.append("                Modification\n");
                sb.append("                    ").append(modification.getAttribute());
            }
        }
        return sb.toString();
    }
}

