/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.MessageException;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;

public class AbstractMessage
implements Message {
    static final long serialVersionUID = 7601738291101182094L;
    private Map controls;
    private final int id;
    private final MessageTypeEnum type;
    private final Map parameters;

    protected AbstractMessage(int id, MessageTypeEnum type) {
        this.id = id;
        this.type = type;
        this.controls = new HashMap();
        this.parameters = new HashMap();
    }

    public int getMessageId() {
        return this.id;
    }

    public Map getControls() {
        return Collections.unmodifiableMap(this.controls);
    }

    public void initControls() {
        this.controls = new HashMap();
    }

    public void add(Control control) throws MessageException {
        this.controls.put(control.getType(), control);
    }

    public void remove(Control control) throws MessageException {
        this.controls.remove(control.getType());
    }

    public MessageTypeEnum getType() {
        return this.type;
    }

    public Object get(Object key) {
        return this.parameters.get(key);
    }

    public Object put(Object key, Object value) {
        return this.parameters.put(key, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message msg = (Message)obj;
        if (msg.getMessageId() != this.id) {
            return false;
        }
        if (msg.getType() != this.type) {
            return false;
        }
        Map controls = msg.getControls();
        if (controls.size() != this.controls.size()) {
            return false;
        }
        Iterator list = this.controls.keySet().iterator();
        while (list.hasNext()) {
            if (controls.containsKey(list.next())) continue;
            return false;
        }
        return true;
    }
}

