/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class Entry
implements Cloneable {
    private int changeType = 0;
    private List modificationList = new LinkedList();
    private Map modificationItems = new HashMap();
    private String dn = null;
    private String newSuperior;
    private String newRdn;
    private boolean deleteOldRdn;
    private Attributes attributeList = new LockableAttributesImpl(true);
    public static final int ADD = 0;
    public static final int MODIFY = 1;
    public static final int MODDN = 2;
    public static final int MODRDN = 3;
    public static final int DELETE = 4;
    private Control control = null;

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public void setChangeType(String changeType) {
        if ("add".equals(changeType)) {
            this.changeType = 0;
        } else if ("modify".equals(changeType)) {
            this.changeType = 1;
        } else if ("moddn".equals(changeType)) {
            this.changeType = 2;
        } else if ("modrdn".equals(changeType)) {
            this.changeType = 3;
        } else if ("delete".equals(changeType)) {
            this.changeType = 4;
        }
    }

    public void addModificationItem(ModificationItemImpl modification) {
        if (this.changeType == 1) {
            ModificationItemImpl newModification = new ModificationItemImpl(modification);
            this.modificationList.add(newModification);
            this.modificationItems.put(newModification.getAttribute().getID(), newModification);
        }
    }

    public void addModificationItem(int modOp, Attribute attr) throws NamingException {
        if (this.changeType == 1) {
            if (this.modificationItems.containsKey(attr.getID())) {
                ModificationItemImpl item = (ModificationItemImpl)this.modificationItems.get(attr.getID());
                Attribute attribute = item.getAttribute();
                NamingEnumeration<?> attrs = attr.getAll();
                while (attrs.hasMoreElements()) {
                    attribute.add(AttributeUtils.cloneValue(attrs.nextElement()));
                }
            } else {
                ModificationItemImpl item = new ModificationItemImpl(modOp, attr);
                this.modificationList.add(item);
                this.modificationItems.put(attr.getID(), item);
            }
        }
    }

    public void addModificationItem(int modOp, String id, Object value) throws NamingException {
        if (this.changeType == 1) {
            LockableAttributeImpl attr = new LockableAttributeImpl(id, value);
            if (this.modificationItems.containsKey(id)) {
                ModificationItemImpl item = (ModificationItemImpl)this.modificationItems.get(id);
                if (item.getModificationOp() != modOp) {
                    throw new NamingException("Bad modification");
                }
                Attribute attribute = item.getAttribute();
                attribute.add(value);
            } else {
                ModificationItemImpl item = new ModificationItemImpl(modOp, attr);
                this.modificationList.add(item);
                this.modificationItems.put(id, item);
            }
        }
    }

    public void addAttribute(Attribute attr) {
        this.attributeList.put(AttributeUtils.toAttributeImpl(attr));
    }

    public void addAttribute(String id, Object value) {
        Attribute attr = this.get(id);
        if (attr != null) {
            attr.add(value);
        } else {
            this.attributeList.put(id, value);
        }
    }

    public void putAttribute(String id, Object value) {
        Attribute attribute = this.attributeList.get(id);
        if (attribute != null) {
            attribute.add(value);
        } else {
            this.attributeList.put(id, value);
        }
    }

    public int getChangeType() {
        return this.changeType;
    }

    public List getModificationItems() {
        return this.modificationList;
    }

    public String getDn() {
        return this.dn;
    }

    public int size() {
        return this.modificationList.size();
    }

    public Attribute get(String attributeId) {
        if ("dn".equalsIgnoreCase(attributeId)) {
            return new LockableAttributeImpl("dn", this.dn);
        }
        return this.attributeList.get(attributeId);
    }

    public Attributes getAttributes() {
        if (this.isEntry()) {
            return this.attributeList;
        }
        return null;
    }

    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(String newSuperior) {
        this.newSuperior = newSuperior;
    }

    public boolean isChangeAdd() {
        return this.changeType == 0;
    }

    public boolean isChangeDelete() {
        return this.changeType == 4;
    }

    public boolean isChangeModDn() {
        return this.changeType == 2;
    }

    public boolean isChangeModRdn() {
        return this.changeType == 3;
    }

    public boolean isChangeModify() {
        return this.changeType == 1;
    }

    public boolean isEntry() {
        return this.changeType == 0;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public Object clone() throws CloneNotSupportedException {
        Iterator<Object> iter;
        Entry clone = (Entry)super.clone();
        if (this.modificationList != null) {
            iter = this.modificationList.iterator();
            while (iter.hasNext()) {
                ModificationItemImpl modif = (ModificationItemImpl)iter.next();
                clone.modificationList.add(modif.clone());
            }
        }
        if (this.modificationItems != null) {
            iter = this.modificationItems.entrySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                ModificationItemImpl modif = (ModificationItemImpl)this.modificationItems.get(key);
                ModificationItemImpl modifClone = new ModificationItemImpl(modif.getModificationOp(), (Attribute)modif.getAttribute().clone());
                clone.modificationItems.put(key, modifClone);
            }
        }
        if (this.attributeList != null) {
            clone.attributeList = (Attributes)this.attributeList.clone();
        }
        return clone;
    }

    private String dumpAttributes() {
        StringBuffer sb = new StringBuffer();
        try {
            NamingEnumeration<? extends Attribute> attrs = this.attributeList.getAll();
            while (attrs.hasMoreElements()) {
                Attribute attribute = (Attribute)attrs.nextElement();
                sb.append("        ").append(attribute.getID()).append(":\n");
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    Object value = values.nextElement();
                    if (value instanceof String) {
                        sb.append("            ").append((String)value).append('\n');
                        continue;
                    }
                    sb.append("            ").append(StringTools.dumpBytes((byte[])value)).append('\n');
                }
            }
        }
        catch (NamingException ne) {
            return "";
        }
        return sb.toString();
    }

    private String dumpModificationItems() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.modificationList.iterator();
        while (iter.hasNext()) {
            ModificationItemImpl modif = (ModificationItemImpl)iter.next();
            sb.append("            Operation: ");
            switch (modif.getModificationOp()) {
                case 1: {
                    sb.append("ADD\n");
                    break;
                }
                case 3: {
                    sb.append("REMOVE\n");
                    break;
                }
                case 2: {
                    sb.append("REPLACE \n");
                }
            }
            Attribute attribute = modif.getAttribute();
            sb.append("                Attribute: ").append(attribute.getID()).append('\n');
            if (attribute.size() == 0) continue;
            try {
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    Object value = values.nextElement();
                    if (value instanceof String) {
                        sb.append("                ").append((String)value).append('\n');
                        continue;
                    }
                    sb.append("                ").append(StringTools.dumpBytes((byte[])value)).append('\n');
                }
            }
            catch (NamingException ne) {
                return "";
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Entry : ").append(this.dn).append('\n');
        if (this.control != null) {
            sb.append("    Control : ").append(this.control).append('\n');
        }
        switch (this.changeType) {
            case 0: {
                sb.append("    Change type is ADD\n");
                sb.append("        Attributes : \n");
                sb.append(this.dumpAttributes());
                break;
            }
            case 1: {
                sb.append("    Change type is MODIFY\n");
                sb.append("        Modifications : \n");
                sb.append(this.dumpModificationItems());
                break;
            }
            case 4: {
                sb.append("    Change type is DELETE\n");
                break;
            }
            case 2: 
            case 3: {
                sb.append("    Change type is ").append(this.changeType == 2 ? "MODDN\n" : "MODRDN\n");
                sb.append("    Delete old RDN : ").append(this.deleteOldRdn ? "true\n" : "false\n");
                sb.append("    New RDN : ").append(this.newRdn).append('\n');
                if (StringTools.isEmpty(this.newSuperior)) break;
                sb.append("    New superior : ").append(this.newSuperior).append('\n');
            }
        }
        return sb.toString();
    }
}

