/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.Map;
import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.message.DerefAliasesEnum;

public class ScopeNode
extends AbstractExprNode {
    private final int scope;
    private final String baseDn;
    private final DerefAliasesEnum derefAliases;

    public ScopeNode(DerefAliasesEnum derefAliases, String baseDn, int scope) {
        super(7);
        this.scope = scope;
        this.baseDn = baseDn;
        this.derefAliases = derefAliases;
    }

    public ScopeNode(Map env, String baseDn, int scope) {
        super(7);
        this.scope = scope;
        this.baseDn = baseDn;
        this.derefAliases = DerefAliasesEnum.getEnum(env);
    }

    public boolean isLeaf() {
        return true;
    }

    public int getScope() {
        return this.scope;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public DerefAliasesEnum getDerefAliases() {
        return this.derefAliases;
    }

    public StringBuffer printToBuffer(StringBuffer buf) {
        switch (this.scope) {
            case 0: {
                buf.append("OBJECT_SCOPE");
                break;
            }
            case 1: {
                buf.append("ONELEVEL_SCOPE");
                break;
            }
            case 2: {
                buf.append("SUBTREE_SCOPE (Estimated)");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        if (this.getAnnotations().containsKey("count")) {
            buf.append(" [");
            buf.append(this.getAnnotations().get("count").toString());
            buf.append(']');
        }
        return buf;
    }

    public void accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            visitor.visit(this);
        }
    }
}

