/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.util.StringTools;

public class ExtendedRequest
extends LdapMessage {
    private OID requestName;
    private byte[] requestValue;
    private transient int extendedRequestLength;
    private transient int oidLength;

    public int getMessageType() {
        return 9;
    }

    public String getRequestName() {
        return this.requestName == null ? "" : this.requestName.toString();
    }

    public void setRequestName(OID requestName) {
        this.requestName = requestName;
    }

    public byte[] getRequestValue() {
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        this.requestValue = requestValue;
    }

    public int computeLength() {
        this.oidLength = this.requestName.toString().length();
        this.extendedRequestLength = 1 + TLV.getNbBytes((int)this.oidLength) + this.oidLength;
        if (this.requestValue != null) {
            this.extendedRequestLength += 1 + TLV.getNbBytes((int)this.requestValue.length) + this.requestValue.length;
        }
        return 1 + TLV.getNbBytes((int)this.extendedRequestLength) + this.extendedRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)119);
            buffer.put(TLV.getBytes((int)this.extendedRequestLength));
            if (this.requestName == null) {
                throw new EncoderException("The request name must not be null");
            }
            buffer.put((byte)-128);
            buffer.put(TLV.getBytes((int)this.oidLength));
            if (this.requestName.getOIDLength() != 0) {
                buffer.put(StringTools.getBytesUtf8(this.requestName.toString()));
            }
            if (this.requestValue != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes((int)this.requestValue.length));
                if (this.requestValue.length != 0) {
                    buffer.put(this.requestValue);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Extended request\n");
        sb.append("        Request name : '").append(this.requestName).append("'\n");
        if (this.requestValue != null) {
            sb.append("        Request value : '").append(StringTools.dumpBytes(this.requestValue)).append("'\n");
        }
        return sb.toString();
    }
}

