/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.Control;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponse;
import org.apache.directory.shared.ldap.codec.LdapResult;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequest;
import org.apache.directory.shared.ldap.codec.actions.AttributeDescAction;
import org.apache.directory.shared.ldap.codec.actions.ControlValueAction;
import org.apache.directory.shared.ldap.codec.actions.ControlsInitAction;
import org.apache.directory.shared.ldap.codec.actions.ErrorMessageAction;
import org.apache.directory.shared.ldap.codec.actions.InitAndFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitApproxMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAssertionValueFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAttributeDescFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAttributeDescListAction;
import org.apache.directory.shared.ldap.codec.actions.InitEqualityMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitExtensibleMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitGreaterOrEqualFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitLessOrEqualFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitNotFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitOrFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitPresentFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitReferralsAction;
import org.apache.directory.shared.ldap.codec.actions.InitSubstringsFilterAction;
import org.apache.directory.shared.ldap.codec.actions.MatchedDNAction;
import org.apache.directory.shared.ldap.codec.actions.ModifyAttributeValueAction;
import org.apache.directory.shared.ldap.codec.actions.ReferralAction;
import org.apache.directory.shared.ldap.codec.actions.ResponseAction;
import org.apache.directory.shared.ldap.codec.actions.ResponseNameAction;
import org.apache.directory.shared.ldap.codec.actions.ResultCodeAction;
import org.apache.directory.shared.ldap.codec.actions.SearchResultAttributeValueAction;
import org.apache.directory.shared.ldap.codec.actions.ServerSASLCredsAction;
import org.apache.directory.shared.ldap.codec.actions.StoreAnyAction;
import org.apache.directory.shared.ldap.codec.actions.StoreFinalAction;
import org.apache.directory.shared.ldap.codec.actions.StoreMatchValueAction;
import org.apache.directory.shared.ldap.codec.actions.StoreReferenceAction;
import org.apache.directory.shared.ldap.codec.actions.StoreTypeMatchingRuleAction;
import org.apache.directory.shared.ldap.codec.actions.ValueAction;
import org.apache.directory.shared.ldap.codec.add.AddRequest;
import org.apache.directory.shared.ldap.codec.add.AddResponse;
import org.apache.directory.shared.ldap.codec.bind.BindRequest;
import org.apache.directory.shared.ldap.codec.bind.BindResponse;
import org.apache.directory.shared.ldap.codec.bind.SaslCredentials;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.compare.CompareRequest;
import org.apache.directory.shared.ldap.codec.compare.CompareResponse;
import org.apache.directory.shared.ldap.codec.del.DelRequest;
import org.apache.directory.shared.ldap.codec.del.DelResponse;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequest;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponse;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequest;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponse;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequest;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponse;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.codec.search.SearchResultDone;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntry;
import org.apache.directory.shared.ldap.codec.search.SearchResultReference;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequest;
import org.apache.directory.shared.ldap.message.AddResponseImpl;
import org.apache.directory.shared.ldap.message.BindResponseImpl;
import org.apache.directory.shared.ldap.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.message.DeleteResponseImpl;
import org.apache.directory.shared.ldap.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.SearchResponseDoneImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapMessageGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)LdapMessageGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new LdapMessageGrammar();

    private LdapMessageGrammar() {
        this.name = LdapMessageGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[112][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, (IAction)new GrammarAction("LdapMessage initialization"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error("The LdapMessage has a zero length. This is not allowed");
                    throw new DecoderException("The LdapMessage should not be empty");
                }
                LdapMessage ldapMessage = new LdapMessage();
                ldapMessageContainer.setLdapMessage(ldapMessage);
            }
        });
        this.transitions[1][2] = new GrammarTransition(1, 2, 2, (IAction)new GrammarAction("Store MessageId"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error("The messageId has a zero length. This is not allowed");
                    throw new DecoderException("The messageId should not be null");
                }
                Value value = tlv.getValue();
                try {
                    int messageId = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                    ldapMessage.setMessageId(messageId);
                    ldapMessageContainer.setMessageId(messageId);
                    if (IS_DEBUG) {
                        log.debug("Ldap Message Id has been decoded : " + messageId);
                    }
                }
                catch (IntegerDecoderException ide) {
                    log.error("The Message Id " + StringTools.dumpBytes(value.getData()) + " is invalid : " + ide.getMessage() + ". The message ID must be between (0 .. 2 147 483 647)");
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[2][66] = new GrammarTransition(2, 5, 66, (IAction)new GrammarAction("Unbind Request initialization"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength != 0) {
                    log.error("The length of a UnBindRequest must be null, the actual value is {}", (Object)new Integer(expectedLength));
                    throw new DecoderException("The length of a UnBindRequest must be null");
                }
                UnBindRequest unBindRequest = new UnBindRequest();
                unBindRequest.setParent(ldapMessage);
                ldapMessage.setProtocolOP(unBindRequest);
                ldapMessageContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[5][160] = new GrammarTransition(5, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][74] = new GrammarTransition(2, 14, 74, (IAction)new GrammarAction("Init del Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                DelRequest delRequest = new DelRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException("The entry must not be null");
                }
                byte[] dnBytes = tlv.getValue().getData();
                try {
                    entry = new LdapDN(dnBytes);
                }
                catch (InvalidNameException ine) {
                    String msg = "The DN to delete : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    DeleteResponseImpl response = new DeleteResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                }
                delRequest.setEntry(entry);
                ldapMessage.setProtocolOP(delRequest);
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Deleting DN {}", (Object)entry);
                }
            }
        });
        this.transitions[14][160] = new GrammarTransition(14, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][80] = new GrammarTransition(2, 20, 80, (IAction)new GrammarAction("Init Abandon Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                if (value == null || value.getData() == null) {
                    String msg = "The AbandonRequest messageId must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                try {
                    int abandonnedMessageId = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                    AbandonRequest abandonRequest = new AbandonRequest();
                    abandonRequest.setAbandonedMessageId(abandonnedMessageId);
                    ldapMessage.setProtocolOP(abandonRequest);
                    if (IS_DEBUG) {
                        log.debug("AbandonMessage Id has been decoded : {}", (Object)new Integer(abandonnedMessageId));
                    }
                    ldapMessageContainer.grammarEndAllowed(true);
                    return;
                }
                catch (IntegerDecoderException ide) {
                    log.error("The Abandonned Message Id {} is invalid : {}. The message ID must be between (0 .. 2 147 483 647)", (Object)StringTools.dumpBytes(value.getData()), (Object)ide.getMessage());
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[20][160] = new GrammarTransition(20, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][96] = new GrammarTransition(2, 3, 96, (IAction)new GrammarAction("Init BindRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = "The BindRequest must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                ldapMessage.setProtocolOP(new BindRequest());
            }
        });
        this.transitions[3][2] = new GrammarTransition(3, 23, 2, (IAction)new GrammarAction("Store version"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    int version = IntegerDecoder.parse((Value)value, (int)1, (int)127);
                    if (IS_DEBUG) {
                        log.debug("Ldap version ", (Object)new Integer(version));
                    }
                    bindRequestMessage.setVersion(version);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The version {} is invalid : {}. The version must be between (0 .. 127)", (Object)StringTools.dumpBytes(value.getData()), (Object)ide.getMessage());
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[23][4] = new GrammarTransition(23, 24, 4, (IAction)new GrammarAction("Store Bind Name value"){

            public void action(IAsn1Container container) throws DecoderException, InvalidNameException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindRequest bindRequestMessage = ldapMessage.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    bindRequestMessage.setName(LdapDN.EMPTY_LDAPDN);
                } else {
                    LdapDN name = LdapDN.EMPTY_LDAPDN;
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        name = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Incorrect DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        BindResponseImpl response = new BindResponseImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                    }
                    bindRequestMessage.setName(name);
                }
                if (IS_DEBUG) {
                    log.debug(" The Bind name is {}", (Object)bindRequestMessage.getName());
                }
            }
        });
        this.transitions[24][128] = new GrammarTransition(24, 25, 128, (IAction)new GrammarAction("Store Bind Simple Authentication value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SimpleAuthentication authentication = null;
                authentication = new SimpleAuthentication();
                authentication.setParent(bindRequestMessage);
                bindRequestMessage.setAuthentication(authentication);
                if (tlv.getLength() == 0) {
                    authentication.setSimple(StringTools.EMPTY_BYTES);
                } else {
                    authentication.setSimple(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The simple authentication is : {}", (Object)authentication.getSimple());
                }
            }
        });
        this.transitions[25][160] = new GrammarTransition(25, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[24][163] = new GrammarTransition(24, 26, 163, (IAction)new GrammarAction("Initialize Bind SASL Authentication"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindRequest bindRequestMessage = ldapMessage.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = "The SaslCredential must not be null";
                    log.error(msg);
                    BindResponseImpl response = new BindResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDCREDENTIALS, bindRequestMessage.getName(), null);
                }
                SaslCredentials authentication = new SaslCredentials();
                authentication.setParent(bindRequestMessage);
                bindRequestMessage.setAuthentication(authentication);
                if (IS_DEBUG) {
                    log.debug("The SaslCredential has been created");
                }
            }
        });
        this.transitions[26][4] = new GrammarTransition(26, 27, 4, (IAction)new GrammarAction("Store SASL mechanism"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindRequest bindRequestMessage = ldapMessage.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SaslCredentials authentication = bindRequestMessage.getSaslAuthentication();
                if (tlv.getLength() == 0) {
                    authentication.setMechanism("");
                } else {
                    authentication.setMechanism(new String(tlv.getValue().getData()));
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The mechanism is : {}", (Object)authentication.getMechanism());
                }
            }
        });
        this.transitions[27][4] = new GrammarTransition(27, 28, 4, (IAction)new GrammarAction("Store SASL credentials"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SaslCredentials credentials = bindRequestMessage.getSaslAuthentication();
                if (tlv.getLength() == 0) {
                    credentials.setCredentials(StringTools.EMPTY_BYTES);
                } else {
                    credentials.setCredentials(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The credentials are : {}", (Object)credentials.getCredentials());
                }
            }
        });
        this.transitions[27][160] = new GrammarTransition(27, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[28][160] = new GrammarTransition(28, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][97] = new GrammarTransition(2, 4, 97, (IAction)new GrammarAction("Init BindReponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindResponse bindResponse = new BindResponse();
                bindResponse.setParent(ldapMessage);
                ldapMessage.setProtocolOP(bindResponse);
            }
        });
        this.transitions[4][10] = new GrammarTransition(4, 29, 10, (IAction)new ResultCodeAction());
        this.transitions[29][4] = new GrammarTransition(29, 30, 4, (IAction)new MatchedDNAction());
        this.transitions[30][4] = new GrammarTransition(30, 31, 4, (IAction)new ErrorMessageAction());
        this.transitions[31][135] = new GrammarTransition(31, 34, 135, (IAction)new ServerSASLCredsAction());
        this.transitions[31][163] = new GrammarTransition(31, 32, 163, (IAction)new InitReferralsAction());
        this.transitions[32][4] = new GrammarTransition(32, 33, 4, (IAction)new ReferralAction());
        this.transitions[33][4] = new GrammarTransition(33, 33, 4, (IAction)new ReferralAction());
        this.transitions[33][135] = new GrammarTransition(33, 34, 135, (IAction)new ServerSASLCredsAction());
        this.transitions[33][160] = new GrammarTransition(33, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[31][160] = new GrammarTransition(31, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[34][160] = new GrammarTransition(34, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[35][4] = new GrammarTransition(35, 36, 4, (IAction)new MatchedDNAction());
        this.transitions[36][4] = new GrammarTransition(36, 37, 4, (IAction)new ErrorMessageAction());
        this.transitions[37][163] = new GrammarTransition(37, 38, 163, (IAction)new GrammarAction("Init referrals list"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                LdapResponse response = ldapMessage.getLdapResponse();
                LdapResult ldapResult = response.getLdapResult();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = "The Referrals must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                ldapResult.initReferrals();
            }
        });
        this.transitions[38][4] = new GrammarTransition(38, 39, 4, (IAction)new ReferralAction());
        this.transitions[39][4] = new GrammarTransition(39, 39, 4, (IAction)new ReferralAction());
        this.transitions[39][160] = new GrammarTransition(39, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[37][160] = new GrammarTransition(37, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][100] = new GrammarTransition(2, 7, 100, (IAction)new GrammarAction("Init SearchResultEntry"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new SearchResultEntry());
            }
        });
        this.transitions[7][4] = new GrammarTransition(7, 100, 4, (IAction)new GrammarAction("Store search result entry object name Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN objectName = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength() == 0) {
                    searchResultEntry.setObjectName(objectName);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        objectName = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "The DN " + StringTools.dumpBytes(dnBytes) + "is invalid : " + ine.getMessage();
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        throw new DecoderException(msg, (Throwable)ine);
                    }
                    searchResultEntry.setObjectName(objectName);
                }
                if (IS_DEBUG) {
                    log.debug("Search Result Entry DN found : {}", (Object)searchResultEntry.getObjectName());
                }
            }
        });
        this.transitions[100][48] = new GrammarTransition(100, 101, 48, (IAction)new GrammarAction("Pop and end allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarEndAllowed(true);
            }
        });
        this.transitions[101][48] = new GrammarTransition(101, 102, 48, null);
        this.transitions[101][160] = new GrammarTransition(101, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[102][4] = new GrammarTransition(102, 103, 4, (IAction)new GrammarAction("Store search result entry object name Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                String type = "";
                if (tlv.getLength() == 0) {
                    searchResultEntry.addAttributeValues(type);
                } else {
                    type = new String(tlv.getValue().getData());
                    searchResultEntry.addAttributeValues(type);
                }
                if (IS_DEBUG) {
                    log.debug("Attribute type : {}", (Object)type);
                }
            }
        });
        this.transitions[103][49] = new GrammarTransition(103, 104, 49, (IAction)new GrammarAction("Grammar end allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarEndAllowed(true);
            }
        });
        this.transitions[104][4] = new GrammarTransition(104, 105, 4, (IAction)new SearchResultAttributeValueAction());
        this.transitions[104][48] = new GrammarTransition(104, 102, 48, null);
        this.transitions[104][160] = new GrammarTransition(104, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[105][4] = new GrammarTransition(105, 105, 4, (IAction)new SearchResultAttributeValueAction());
        this.transitions[105][48] = new GrammarTransition(105, 102, 48, null);
        this.transitions[105][160] = new GrammarTransition(105, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][101] = new GrammarTransition(2, 8, 101, (IAction)new GrammarAction("Init search Result Done"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new SearchResultDone());
                log.debug("Search Result Done found");
            }
        });
        this.transitions[8][10] = new GrammarTransition(8, 35, 10, (IAction)new ResultCodeAction());
        this.transitions[2][102] = new GrammarTransition(2, 10, 102, (IAction)new GrammarAction("Init ModifyRequest"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyRequest());
            }
        });
        this.transitions[10][4] = new GrammarTransition(10, 55, 4, (IAction)new GrammarAction("Store Modify request object Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN object = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength() == 0) {
                    modifyRequest.setObject(object);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        object = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        ModifyResponseImpl response = new ModifyResponseImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                    }
                    modifyRequest.setObject(object);
                }
                if (IS_DEBUG) {
                    log.debug("Modification of DN {}", (Object)modifyRequest.getObject());
                }
            }
        });
        this.transitions[55][48] = new GrammarTransition(55, 56, 48, (IAction)new GrammarAction("Init modifications array list"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                modifyRequest.initModifications();
            }
        });
        this.transitions[56][48] = new GrammarTransition(56, 57, 48, null);
        this.transitions[57][10] = new GrammarTransition(57, 58, 10, (IAction)new GrammarAction("Store operation type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int operation = 0;
                try {
                    operation = IntegerDecoder.parse((Value)tlv.getValue(), (int)0, (int)2);
                }
                catch (IntegerDecoderException ide) {
                    String msg = "Invalid operation ( " + StringTools.dumpBytes(tlv.getValue().getData()) + "), it should be 0, 1 or 2";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                modifyRequest.setCurrentOperation(operation);
                if (IS_DEBUG) {
                    switch (operation) {
                        case 0: {
                            log.debug("Modification operation : ADD");
                            break;
                        }
                        case 1: {
                            log.debug("Modification operation : DELETE");
                            break;
                        }
                        case 2: {
                            log.debug("Modification operation : REPLACE");
                        }
                    }
                }
            }
        });
        this.transitions[58][48] = new GrammarTransition(58, 59, 48, null);
        this.transitions[59][4] = new GrammarTransition(59, 60, 4, (IAction)new GrammarAction("Store type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                String type = null;
                if (tlv.getLength() == 0) {
                    String msg = "The type can't be null";
                    log.error(msg);
                    ModifyResponseImpl response = new ModifyResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDATTRIBUTESYNTAX, modifyRequest.getObject(), null);
                }
                type = new String(tlv.getValue().getData());
                modifyRequest.addAttributeTypeAndValues(type);
                if (IS_DEBUG) {
                    log.debug("Modifying type : {}", (Object)type);
                }
            }
        });
        this.transitions[60][49] = new GrammarTransition(60, 61, 49, (IAction)new GrammarAction("Init Attribute vals"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.debug("No vals for this attribute");
                }
                ldapMessageContainer.grammarEndAllowed(true);
                log.debug("Some vals are to be decoded");
            }
        });
        this.transitions[61][4] = new GrammarTransition(61, 62, 4, (IAction)new ModifyAttributeValueAction());
        this.transitions[61][48] = new GrammarTransition(61, 57, 48, null);
        this.transitions[61][160] = new GrammarTransition(61, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[62][4] = new GrammarTransition(62, 62, 4, (IAction)new ModifyAttributeValueAction());
        this.transitions[62][48] = new GrammarTransition(62, 57, 48, null);
        this.transitions[62][160] = new GrammarTransition(62, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][103] = new GrammarTransition(2, 11, 103, (IAction)new GrammarAction("Init ModifyResponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyResponse());
                log.debug("Modify response");
            }
        });
        this.transitions[11][10] = new GrammarTransition(11, 35, 10, (IAction)new ResultCodeAction());
        this.transitions[2][104] = new GrammarTransition(2, 12, 104, (IAction)new GrammarAction("Init addRequest"){

            public void action(IAsn1Container container) throws DecoderException, NamingException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = "The AddRequest must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                ldapMessage.setProtocolOP(new AddRequest());
            }
        });
        this.transitions[12][4] = new GrammarTransition(12, 49, 4, (IAction)new GrammarAction("Store add request object Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddRequest addRequest = ldapMessage.getAddRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = "Empty entry DN given";
                    log.error(msg);
                    AddResponseImpl response = new AddResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.NAMINGVIOLATION, LdapDN.EMPTY_LDAPDN, null);
                }
                LdapDN entry = null;
                byte[] dnBytes = tlv.getValue().getData();
                try {
                    entry = new LdapDN(dnBytes);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    AddResponseImpl response = new AddResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                }
                addRequest.setEntry(entry);
                log.debug("Adding an entry with DN : {}", (Object)addRequest.getEntry());
            }
        });
        this.transitions[49][48] = new GrammarTransition(49, 50, 48, (IAction)new GrammarAction("Init attributes array list"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddRequest addRequest = ldapMessage.getAddRequest();
                addRequest.initAttributes();
            }
        });
        this.transitions[50][48] = new GrammarTransition(50, 51, 48, null);
        this.transitions[51][4] = new GrammarTransition(51, 52, 4, (IAction)new GrammarAction("Store attribute type"){

            public void action(IAsn1Container container) throws DecoderException, NamingException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                AddRequest addRequest = ldapMessage.getAddRequest();
                if (tlv.getLength() == 0) {
                    String msg = "Null or empty types are not allowed";
                    log.error(msg);
                    AddResponseImpl response = new AddResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDATTRIBUTESYNTAX, addRequest.getEntry(), null);
                }
                String type = new String(tlv.getValue().getData());
                addRequest.addAttributeType(type);
                if (IS_DEBUG) {
                    log.debug("Adding type {}", (Object)type);
                }
            }
        });
        this.transitions[52][49] = new GrammarTransition(52, 53, 49, null);
        this.transitions[53][4] = new GrammarTransition(53, 54, 4, (IAction)new ValueAction());
        this.transitions[54][4] = new GrammarTransition(54, 54, 4, (IAction)new ValueAction());
        this.transitions[54][48] = new GrammarTransition(54, 51, 48, null);
        this.transitions[54][160] = new GrammarTransition(54, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][105] = new GrammarTransition(2, 13, 105, (IAction)new GrammarAction("Init AddResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength == 0) {
                    String msg = "The AddResponse must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                AddResponse addResponse = new AddResponse();
                ldapMessage.setProtocolOP(addResponse);
                log.debug("Add Response");
            }
        });
        this.transitions[13][10] = new GrammarTransition(13, 35, 10, (IAction)new ResultCodeAction());
        this.transitions[2][107] = new GrammarTransition(2, 15, 107, (IAction)new GrammarAction("Init DelResponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new DelResponse());
                log.debug("Del response ");
            }
        });
        this.transitions[15][10] = new GrammarTransition(15, 35, 10, (IAction)new ResultCodeAction());
        this.transitions[2][108] = new GrammarTransition(2, 16, 108, (IAction)new GrammarAction("Init Modify DN Request"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyDNRequest());
            }
        });
        this.transitions[16][4] = new GrammarTransition(16, 63, 4, (IAction)new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException("The entry must nut be null");
                }
                byte[] dnBytes = tlv.getValue().getData();
                try {
                    entry = new LdapDN(dnBytes);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                }
                modifyDNRequest.setEntry(entry);
                if (IS_DEBUG) {
                    log.debug("Modifying DN {}", (Object)entry);
                }
            }
        });
        this.transitions[63][4] = new GrammarTransition(63, 64, 4, (IAction)new GrammarAction("Store new RDN"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Rdn newRdn = null;
                if (tlv.getLength() == 0) {
                    String msg = "The newrdn must not be null";
                    log.error(msg);
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, modifyDNRequest.getEntry(), null);
                }
                byte[] dnBytes = tlv.getValue().getData();
                try {
                    LdapDN dn = new LdapDN(dnBytes);
                    newRdn = dn.getRdn(0);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid new RDN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, modifyDNRequest.getEntry(), ine);
                }
                modifyDNRequest.setNewRDN(newRdn);
                if (IS_DEBUG) {
                    log.debug("Modifying with new RDN {}", (Object)newRdn);
                }
            }
        });
        this.transitions[64][1] = new GrammarTransition(64, 65, 1, (IAction)new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                Value value = tlv.getValue();
                try {
                    modifyDNRequest.setDeleteOldRDN(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The oldRDN flag {} is invalid : {}. It should be 0 or 255", (Object)StringTools.dumpBytes(value.getData()), (Object)bde.getMessage());
                    throw new DecoderException(bde.getMessage());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        log.debug(" Old RDN attributes will be deleted");
                    } else {
                        log.debug(" Old RDN attributes will be retained");
                    }
                }
            }
        });
        this.transitions[65][128] = new GrammarTransition(65, 66, 128, (IAction)new GrammarAction("Store new superior"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN newSuperior = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength() == 0) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        throw new DecoderException("The new superior must nut be null if the flag 'delete old DN' is set to true");
                    }
                    log.warn("The new superior is null, so we will change the entry");
                    modifyDNRequest.setNewSuperior(newSuperior);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        newSuperior = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid new superior DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        ModifyDnResponseImpl response = new ModifyDnResponseImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, modifyDNRequest.getEntry(), ine);
                    }
                    modifyDNRequest.setNewSuperior(newSuperior);
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("New superior DN {}", (Object)newSuperior);
                }
            }
        });
        this.transitions[65][160] = new GrammarTransition(65, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[66][160] = new GrammarTransition(66, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][109] = new GrammarTransition(2, 17, 109, (IAction)new GrammarAction("Init ModifyDNResponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyDNResponse());
                log.debug("Modify DN response ");
            }
        });
        this.transitions[17][10] = new GrammarTransition(17, 35, 10, (IAction)new ResultCodeAction());
        this.transitions[2][110] = new GrammarTransition(2, 18, 110, (IAction)new GrammarAction("Init Compare Request"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new CompareRequest());
            }
        });
        this.transitions[18][4] = new GrammarTransition(18, 67, 4, (IAction)new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException("The entry must not be null");
                }
                byte[] dnBytes = tlv.getValue().getData();
                try {
                    entry = new LdapDN(dnBytes);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    CompareResponseImpl response = new CompareResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                }
                compareRequest.setEntry(entry);
                if (IS_DEBUG) {
                    log.debug("Comparing DN {}", (Object)entry);
                }
            }
        });
        this.transitions[67][48] = new GrammarTransition(67, 68, 48, null);
        this.transitions[68][4] = new GrammarTransition(68, 69, 4, (IAction)new GrammarAction("Store attribute desc"){

            public void action(IAsn1Container container) throws DecoderException, NamingException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = "The attribute description must not be null";
                    log.error(msg);
                    CompareResponseImpl response = new CompareResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDATTRIBUTESYNTAX, compareRequest.getEntry(), null);
                }
                String type = new String(tlv.getValue().getData());
                compareRequest.setAttributeDesc(type);
                if (IS_DEBUG) {
                    log.debug("Comparing attribute description {}", (Object)compareRequest.getAttributeDesc());
                }
            }
        });
        this.transitions[69][4] = new GrammarTransition(69, 70, 4, (IAction)new GrammarAction("Store assertion value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    compareRequest.setAssertionValue("");
                } else if (ldapMessageContainer.isBinary(compareRequest.getAttributeDesc())) {
                    compareRequest.setAssertionValue(tlv.getValue().getData());
                    if (IS_DEBUG) {
                        log.debug("Comparing attribute value {}", (Object)StringTools.dumpBytes((byte[])compareRequest.getAssertionValue()));
                    }
                } else {
                    compareRequest.setAssertionValue(StringTools.utf8ToString(tlv.getValue().getData()));
                    if (log.isDebugEnabled()) {
                        log.debug("Comparing attribute value {}", compareRequest.getAssertionValue());
                    }
                }
                ldapMessageContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[70][160] = new GrammarTransition(70, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][111] = new GrammarTransition(2, 19, 111, (IAction)new GrammarAction("Init CompareResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = "The CompareResponse must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                ldapMessage.setProtocolOP(new CompareResponse());
                log.debug("Compare response ");
            }
        });
        this.transitions[19][10] = new GrammarTransition(19, 35, 10, (IAction)new ResultCodeAction());
        this.transitions[2][115] = new GrammarTransition(2, 9, 115, (IAction)new GrammarAction("Init SearchResultReference"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultReference searchResultReference = new SearchResultReference();
                searchResultReference.setParent(ldapMessage);
                ldapMessage.setProtocolOP(searchResultReference);
            }
        });
        this.transitions[9][4] = new GrammarTransition(9, 106, 4, (IAction)new StoreReferenceAction());
        this.transitions[106][4] = new GrammarTransition(106, 106, 4, (IAction)new StoreReferenceAction());
        this.transitions[106][160] = new GrammarTransition(106, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][119] = new GrammarTransition(2, 21, 119, (IAction)new GrammarAction("Init Extended Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ExtendedRequest());
            }
        });
        this.transitions[21][128] = new GrammarTransition(21, 40, 128, (IAction)new GrammarAction("Store name"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedRequest extendedRequest = ldapMessage.getExtendedRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error("The name must not be null");
                    throw new DecoderException("The name must not be null");
                }
                byte[] requestNameBytes = tlv.getValue().getData();
                try {
                    OID oid = new OID(StringTools.utf8ToString(requestNameBytes));
                    extendedRequest.setRequestName(oid);
                }
                catch (DecoderException de) {
                    String msg = "The Request name is not a valid OID : " + StringTools.utf8ToString(requestNameBytes) + " (" + StringTools.dumpBytes(requestNameBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)de.getMessage());
                    throw de;
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("OID read : {}", (Object)extendedRequest.getRequestName());
                }
            }
        });
        this.transitions[40][129] = new GrammarTransition(40, 41, 129, (IAction)new GrammarAction("Store value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedRequest extendedRequest = ldapMessage.getExtendedRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    extendedRequest.setRequestValue(StringTools.EMPTY_BYTES);
                } else {
                    extendedRequest.setRequestValue(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Extended value : {}", (Object)extendedRequest.getRequestValue());
                }
            }
        });
        this.transitions[40][160] = new GrammarTransition(40, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[41][160] = new GrammarTransition(41, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[2][120] = new GrammarTransition(2, 22, 120, (IAction)new GrammarAction("Init Extended Reponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ExtendedResponse());
            }
        });
        this.transitions[22][10] = new GrammarTransition(22, 44, 10, (IAction)new ResultCodeAction());
        this.transitions[44][4] = new GrammarTransition(44, 45, 4, (IAction)new MatchedDNAction());
        this.transitions[45][4] = new GrammarTransition(45, 46, 4, (IAction)new ErrorMessageAction());
        this.transitions[46][163] = new GrammarTransition(46, 47, 163, (IAction)new InitReferralsAction());
        this.transitions[47][4] = new GrammarTransition(47, 48, 4, (IAction)new ReferralAction());
        this.transitions[48][4] = new GrammarTransition(48, 48, 4, (IAction)new ReferralAction());
        this.transitions[48][138] = new GrammarTransition(48, 42, 138, (IAction)new ResponseNameAction());
        this.transitions[48][139] = new GrammarTransition(48, 43, 139, (IAction)new ResponseAction());
        this.transitions[48][160] = new GrammarTransition(48, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[46][160] = new GrammarTransition(46, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[46][138] = new GrammarTransition(46, 42, 138, (IAction)new ResponseNameAction());
        this.transitions[42][139] = new GrammarTransition(42, 43, 139, (IAction)new ResponseAction());
        this.transitions[42][160] = new GrammarTransition(42, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[46][139] = new GrammarTransition(46, 43, 139, (IAction)new ResponseAction());
        this.transitions[43][160] = new GrammarTransition(43, 107, 160, (IAction)new ControlsInitAction());
        GrammarAction addControl = new GrammarAction("Add Control"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage message = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength == 0) {
                    log.error("The length of a control must not be null");
                    throw new DecoderException("The length of a control must not be null");
                }
                Control control = new Control();
                message.addControl(control);
            }
        };
        this.transitions[107][48] = new GrammarTransition(107, 108, 48, (IAction)addControl);
        this.transitions[108][4] = new GrammarTransition(108, 109, 4, (IAction)new GrammarAction("Set Control Type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage message = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = message.getCurrentControl();
                if (tlv.getLength() == 0) {
                    log.error("The OID must not be null");
                    throw new DecoderException("The OID must not be null");
                }
                byte[] value = tlv.getValue().getData();
                String oidValue = StringTools.asciiBytesToString(value);
                try {
                    new OID(oidValue);
                }
                catch (DecoderException de) {
                    log.error("The control type " + StringTools.dumpBytes(value) + " is not a valid OID : " + de.getMessage());
                    throw de;
                }
                control.setControlType(oidValue);
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Control OID : " + control.getControlType());
                }
            }
        });
        this.transitions[109][1] = new GrammarTransition(109, 110, 4, (IAction)new GrammarAction("Set Criticality"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage message = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = message.getCurrentControl();
                Value value = tlv.getValue();
                try {
                    control.setCriticality(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The control criticality flag " + StringTools.dumpBytes(value.getData()) + " is invalid : " + bde.getMessage() + ". It should be 0 or 255");
                    throw new DecoderException(bde.getMessage());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Control criticality : " + control.getCriticality());
                }
            }
        });
        this.transitions[110][4] = new GrammarTransition(110, 111, 4, (IAction)new ControlValueAction());
        this.transitions[109][4] = new GrammarTransition(109, 111, 4, (IAction)new ControlValueAction());
        this.transitions[109][48] = new GrammarTransition(109, 108, 48, (IAction)addControl);
        this.transitions[110][48] = new GrammarTransition(110, 108, 48, (IAction)addControl);
        this.transitions[111][48] = new GrammarTransition(111, 108, 48, (IAction)addControl);
        this.transitions[2][99] = new GrammarTransition(2, 6, 99, (IAction)new GrammarAction("Init SearchRequest"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new SearchRequest());
            }
        });
        this.transitions[6][4] = new GrammarTransition(6, 71, 4, (IAction)new GrammarAction("store base object value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN baseObject = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength() != 0) {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        baseObject = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid root DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        SearchResponseDoneImpl response = new SearchResponseDoneImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                    }
                }
                searchRequest.setBaseObject(baseObject);
                log.debug("Searching with root DN : {}", (Object)baseObject);
            }
        });
        this.transitions[71][10] = new GrammarTransition(71, 72, 10, (IAction)new GrammarAction("store scope value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int scope = 0;
                try {
                    scope = IntegerDecoder.parse((Value)value, (int)0, (int)2);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The scope is not in [0..2] : {}", (Object)value.toString());
                    throw new DecoderException("The scope is not in [0..2] : " + value.toString());
                }
                searchRequest.setScope(scope);
                if (IS_DEBUG) {
                    switch (scope) {
                        case 0: {
                            log.debug("Searching within BASE_OBJECT scope ");
                            break;
                        }
                        case 1: {
                            log.debug("Searching within SINGLE_LEVEL scope ");
                            break;
                        }
                        case 2: {
                            log.debug("Searching within WHOLE_SUBTREE scope ");
                        }
                    }
                }
            }
        });
        this.transitions[72][10] = new GrammarTransition(72, 73, 10, (IAction)new GrammarAction("store derefAliases value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int derefAliases = 0;
                try {
                    derefAliases = IntegerDecoder.parse((Value)value, (int)0, (int)3);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The derefAlias is not in [0..3] : {}", (Object)value.toString());
                    throw new DecoderException("The derefAlias is not in [0..3] : " + value.toString());
                }
                searchRequest.setDerefAliases(derefAliases);
                if (IS_DEBUG) {
                    switch (derefAliases) {
                        case 0: {
                            log.debug("Handling object strategy : NEVER_DEREF_ALIASES");
                            break;
                        }
                        case 1: {
                            log.debug("Handling object strategy : DEREF_IN_SEARCHING");
                            break;
                        }
                        case 2: {
                            log.debug("Handling object strategy : DEREF_FINDING_BASE_OBJ");
                            break;
                        }
                        case 3: {
                            log.debug("Handling object strategy : DEREF_ALWAYS");
                        }
                    }
                }
            }
        });
        this.transitions[73][2] = new GrammarTransition(73, 74, 2, (IAction)new GrammarAction("store sizeLimit value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int sizeLimit = 0;
                try {
                    sizeLimit = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The sizeLimit is not a valid Integer: {}", (Object)value.toString());
                    throw new DecoderException("The sizeLimit is not a valid Integer: " + value.toString());
                }
                searchRequest.setSizeLimit(sizeLimit);
                if (IS_DEBUG) {
                    log.debug("The sizeLimit value is set to {} objects", (Object)new Integer(sizeLimit));
                }
            }
        });
        this.transitions[74][2] = new GrammarTransition(74, 75, 2, (IAction)new GrammarAction("store timeLimit value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int timeLimit = 0;
                try {
                    timeLimit = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The timeLimit is not a valid Integer: {}", (Object)value.toString());
                    throw new DecoderException("The timeLimit is not a valid Integer: " + value.toString());
                }
                searchRequest.setTimeLimit(timeLimit);
                if (IS_DEBUG) {
                    log.debug("The timeLimit value is set to {} seconds", (Object)new Integer(timeLimit));
                }
            }
        });
        this.transitions[75][1] = new GrammarTransition(75, 76, 1, (IAction)new GrammarAction("store typesOnly value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    searchRequest.setTypesOnly(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The types only flag {} is invalid : {}. It should be 0 or 255", (Object)StringTools.dumpBytes(value.getData()), (Object)bde.getMessage());
                    throw new DecoderException(bde.getMessage());
                }
                if (IS_DEBUG) {
                    log.debug("The search will return {}", (Object)(searchRequest.isTypesOnly() ? "only attributs type" : "attributes types and values"));
                }
            }
        });
        this.transitions[76][160] = new GrammarTransition(76, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[76][161] = new GrammarTransition(76, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[76][162] = new GrammarTransition(76, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[76][163] = new GrammarTransition(76, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[76][164] = new GrammarTransition(76, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[76][165] = new GrammarTransition(76, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[76][166] = new GrammarTransition(76, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[76][135] = new GrammarTransition(76, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[76][168] = new GrammarTransition(76, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[76][169] = new GrammarTransition(76, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[77][160] = new GrammarTransition(77, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[77][161] = new GrammarTransition(77, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[77][162] = new GrammarTransition(77, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[77][163] = new GrammarTransition(77, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[77][164] = new GrammarTransition(77, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[77][165] = new GrammarTransition(77, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[77][166] = new GrammarTransition(77, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[77][135] = new GrammarTransition(77, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[77][168] = new GrammarTransition(77, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[77][169] = new GrammarTransition(77, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[78][160] = new GrammarTransition(78, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[78][161] = new GrammarTransition(78, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[78][162] = new GrammarTransition(78, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[78][163] = new GrammarTransition(78, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[78][164] = new GrammarTransition(78, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[78][165] = new GrammarTransition(78, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[78][166] = new GrammarTransition(78, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[78][135] = new GrammarTransition(78, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[78][168] = new GrammarTransition(78, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[78][169] = new GrammarTransition(78, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[79][160] = new GrammarTransition(79, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[79][161] = new GrammarTransition(79, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[79][162] = new GrammarTransition(79, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[79][163] = new GrammarTransition(79, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[79][164] = new GrammarTransition(79, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[79][165] = new GrammarTransition(79, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[79][166] = new GrammarTransition(79, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[79][135] = new GrammarTransition(79, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[79][168] = new GrammarTransition(79, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[79][169] = new GrammarTransition(79, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[80][4] = new GrammarTransition(80, 87, 4, (IAction)new InitAttributeDescFilterAction());
        this.transitions[87][4] = new GrammarTransition(87, 88, 4, (IAction)new InitAssertionValueFilterAction());
        this.transitions[88][160] = new GrammarTransition(88, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[88][161] = new GrammarTransition(88, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[88][162] = new GrammarTransition(88, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[88][163] = new GrammarTransition(88, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[88][164] = new GrammarTransition(88, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[88][165] = new GrammarTransition(88, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[88][166] = new GrammarTransition(88, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[88][135] = new GrammarTransition(88, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[88][168] = new GrammarTransition(88, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[88][169] = new GrammarTransition(88, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[88][48] = new GrammarTransition(88, 89, 48, (IAction)new InitAttributeDescListAction());
        this.transitions[89][4] = new GrammarTransition(89, 90, 4, (IAction)new AttributeDescAction());
        this.transitions[89][160] = new GrammarTransition(89, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[90][4] = new GrammarTransition(90, 90, 4, (IAction)new AttributeDescAction());
        this.transitions[90][160] = new GrammarTransition(90, 107, 160, (IAction)new ControlsInitAction());
        this.transitions[82][4] = new GrammarTransition(82, 87, 4, (IAction)new InitAttributeDescFilterAction());
        this.transitions[83][4] = new GrammarTransition(83, 87, 4, (IAction)new InitAttributeDescFilterAction());
        this.transitions[81][4] = new GrammarTransition(81, 91, 4, (IAction)new GrammarAction("Store substring filter type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    log.error("The attribute description should not be null");
                    throw new DecoderException("The attribute description should not be null");
                }
                String type = new String(tlv.getValue().getData());
                substringFilter.setType(type);
                searchRequest.setTerminalFilter(substringFilter);
            }
        });
        this.transitions[91][48] = new GrammarTransition(91, 92, 48, (IAction)new GrammarAction("Substring Filter substringsSequence "){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    log.error("The substrings sequence is empty");
                    throw new DecoderException("The substring sequence is empty");
                }
            }
        });
        this.transitions[92][128] = new GrammarTransition(92, 93, 128, (IAction)new GrammarAction("Store substring filter initial Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    log.error("The substring initial filter is empty");
                    throw new DecoderException("The substring initial filter is empty");
                }
                substringFilter.setInitialSubstrings(new String(tlv.getValue().getData()));
                searchRequest.unstackFilters(container);
            }
        });
        this.transitions[92][129] = new GrammarTransition(92, 94, 129, (IAction)new StoreAnyAction());
        this.transitions[92][130] = new GrammarTransition(92, 95, 130, (IAction)new StoreFinalAction());
        this.transitions[93][129] = new GrammarTransition(93, 94, 129, (IAction)new StoreAnyAction());
        this.transitions[93][130] = new GrammarTransition(93, 95, 130, (IAction)new StoreFinalAction());
        this.transitions[93][48] = new GrammarTransition(93, 89, 48, (IAction)new InitAttributeDescListAction());
        this.transitions[93][160] = new GrammarTransition(93, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[93][161] = new GrammarTransition(93, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[93][162] = new GrammarTransition(93, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[93][163] = new GrammarTransition(93, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[93][164] = new GrammarTransition(93, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[93][165] = new GrammarTransition(93, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[93][166] = new GrammarTransition(93, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[93][135] = new GrammarTransition(93, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[93][168] = new GrammarTransition(93, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[93][169] = new GrammarTransition(93, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[94][130] = new GrammarTransition(94, 95, 130, (IAction)new StoreFinalAction());
        this.transitions[94][129] = new GrammarTransition(94, 94, 129, (IAction)new StoreAnyAction());
        this.transitions[94][48] = new GrammarTransition(94, 89, 48, (IAction)new InitAttributeDescListAction());
        this.transitions[94][160] = new GrammarTransition(94, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[94][161] = new GrammarTransition(94, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[94][162] = new GrammarTransition(94, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[94][163] = new GrammarTransition(94, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[94][164] = new GrammarTransition(94, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[94][165] = new GrammarTransition(94, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[94][166] = new GrammarTransition(94, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[94][135] = new GrammarTransition(94, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[94][168] = new GrammarTransition(94, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[94][169] = new GrammarTransition(94, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[95][48] = new GrammarTransition(95, 89, 48, (IAction)new InitAttributeDescListAction());
        this.transitions[95][160] = new GrammarTransition(95, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[95][161] = new GrammarTransition(95, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[95][162] = new GrammarTransition(95, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[95][163] = new GrammarTransition(95, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[95][164] = new GrammarTransition(95, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[95][165] = new GrammarTransition(95, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[95][166] = new GrammarTransition(95, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[95][135] = new GrammarTransition(95, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[95][168] = new GrammarTransition(95, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[95][169] = new GrammarTransition(95, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[84][160] = new GrammarTransition(84, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[84][161] = new GrammarTransition(84, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[84][162] = new GrammarTransition(84, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[84][163] = new GrammarTransition(84, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[84][164] = new GrammarTransition(84, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[84][165] = new GrammarTransition(84, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[84][166] = new GrammarTransition(84, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[84][135] = new GrammarTransition(84, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[84][168] = new GrammarTransition(84, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[84][169] = new GrammarTransition(84, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[84][48] = new GrammarTransition(84, 89, 48, (IAction)new InitAttributeDescListAction());
        this.transitions[85][4] = new GrammarTransition(85, 87, 4, (IAction)new InitAttributeDescFilterAction());
        this.transitions[86][129] = new GrammarTransition(86, 96, 129, (IAction)new GrammarAction("Store matching rule Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    log.error("The matching rule is empty");
                    throw new DecoderException("Invalid matching rule : it can't be empty");
                }
                extensibleMatchFilter.setMatchingRule(new String(tlv.getValue().getData()));
            }
        });
        this.transitions[86][130] = new GrammarTransition(86, 97, 130, (IAction)new StoreTypeMatchingRuleAction());
        this.transitions[86][131] = new GrammarTransition(86, 98, 131, (IAction)new StoreMatchValueAction());
        this.transitions[96][130] = new GrammarTransition(96, 97, 130, (IAction)new StoreTypeMatchingRuleAction());
        this.transitions[96][131] = new GrammarTransition(96, 98, 131, (IAction)new StoreMatchValueAction());
        this.transitions[97][131] = new GrammarTransition(97, 98, 131, (IAction)new StoreMatchValueAction());
        this.transitions[98][132] = new GrammarTransition(98, 99, 132, (IAction)new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
                Value value = tlv.getValue();
                try {
                    extensibleMatchFilter.setDnAttributes(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The DN attributes flag {} is invalid : {}. It should be 0 or 255", (Object)StringTools.dumpBytes(value.getData()), (Object)bde.getMessage());
                    throw new DecoderException(bde.getMessage());
                }
                if (IS_DEBUG) {
                    log.debug("DN Attributes : {}", (Object)new Boolean(extensibleMatchFilter.isDnAttributes()));
                }
                searchRequest.unstackFilters(ldapMessageContainer);
            }
        });
        this.transitions[98][160] = new GrammarTransition(98, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[98][161] = new GrammarTransition(98, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[98][162] = new GrammarTransition(98, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[98][163] = new GrammarTransition(98, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[98][164] = new GrammarTransition(98, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[98][165] = new GrammarTransition(98, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[98][166] = new GrammarTransition(98, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[98][135] = new GrammarTransition(98, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[98][168] = new GrammarTransition(98, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[98][169] = new GrammarTransition(98, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[98][48] = new GrammarTransition(98, 89, 48, (IAction)new InitAttributeDescListAction());
        this.transitions[99][160] = new GrammarTransition(99, 77, 160, (IAction)new InitAndFilterAction());
        this.transitions[99][161] = new GrammarTransition(99, 78, 161, (IAction)new InitOrFilterAction());
        this.transitions[99][162] = new GrammarTransition(99, 79, 162, (IAction)new InitNotFilterAction());
        this.transitions[99][163] = new GrammarTransition(99, 80, 163, (IAction)new InitEqualityMatchFilterAction());
        this.transitions[99][164] = new GrammarTransition(99, 81, 164, (IAction)new InitSubstringsFilterAction());
        this.transitions[99][165] = new GrammarTransition(99, 82, 165, (IAction)new InitGreaterOrEqualFilterAction());
        this.transitions[99][166] = new GrammarTransition(99, 83, 166, (IAction)new InitLessOrEqualFilterAction());
        this.transitions[99][135] = new GrammarTransition(99, 84, 135, (IAction)new InitPresentFilterAction());
        this.transitions[99][168] = new GrammarTransition(99, 85, 168, (IAction)new InitApproxMatchFilterAction());
        this.transitions[99][169] = new GrammarTransition(99, 86, 169, (IAction)new InitExtensibleMatchFilterAction());
        this.transitions[99][48] = new GrammarTransition(99, 89, 48, (IAction)new InitAttributeDescListAction());
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

