/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.UserPermission;

public class UserFirstACIItem
extends ACIItem {
    private static final long serialVersionUID = 5587483838404246148L;
    private final Collection userClasses;
    private final Collection userPermissions;
    static /* synthetic */ Class class$org$apache$directory$shared$ldap$aci$UserClass;
    static /* synthetic */ Class class$org$apache$directory$shared$ldap$aci$UserPermission;

    public UserFirstACIItem(String identificationTag, int precedence, AuthenticationLevel authenticationLevel, Collection userClasses, Collection userPermissions) {
        super(identificationTag, precedence, authenticationLevel);
        Iterator i = userClasses.iterator();
        while (i.hasNext()) {
            if ((class$org$apache$directory$shared$ldap$aci$UserClass == null ? UserFirstACIItem.class$("org.apache.directory.shared.ldap.aci.UserClass") : class$org$apache$directory$shared$ldap$aci$UserClass).isAssignableFrom(i.next().getClass())) continue;
            throw new IllegalArgumentException("userClasses contains an element which is not a user class.");
        }
        i = userPermissions.iterator();
        while (i.hasNext()) {
            if ((class$org$apache$directory$shared$ldap$aci$UserPermission == null ? UserFirstACIItem.class$("org.apache.directory.shared.ldap.aci.UserPermission") : class$org$apache$directory$shared$ldap$aci$UserPermission).isAssignableFrom(i.next().getClass())) continue;
            throw new IllegalArgumentException("userPermissions contains an element which is not a user permission.");
        }
        this.userClasses = Collections.unmodifiableCollection(new ArrayList(userClasses));
        this.userPermissions = Collections.unmodifiableCollection(new ArrayList(userPermissions));
    }

    public Collection getUserClasses() {
        return this.userClasses;
    }

    public Collection getUserPermission() {
        return this.userPermissions;
    }

    public String toString() {
        return "userFirstACIItem: identificationTag=" + this.getIdentificationTag() + ", " + "precedence=" + this.getPrecedence() + ", " + "authenticationLevel=" + this.getAuthenticationLevel() + ", " + "userClasses=" + this.userClasses + ", " + "userPermissions=" + this.userPermissions;
    }

    public Collection toTuples() {
        ArrayList<ACITuple> tuples = new ArrayList<ACITuple>();
        Iterator i = this.userPermissions.iterator();
        while (i.hasNext()) {
            int precedence;
            UserPermission userPermission = (UserPermission)i.next();
            Set grants = userPermission.getGrants();
            Set denials = userPermission.getDenials();
            int n = precedence = userPermission.getPrecedence() >= 0 ? userPermission.getPrecedence() : this.getPrecedence();
            if (grants.size() > 0) {
                tuples.add(new ACITuple(this.getUserClasses(), this.getAuthenticationLevel(), userPermission.getProtectedItems(), UserFirstACIItem.toMicroOperations(grants), true, precedence));
            }
            if (denials.size() <= 0) continue;
            tuples.add(new ACITuple(this.getUserClasses(), this.getAuthenticationLevel(), userPermission.getProtectedItems(), UserFirstACIItem.toMicroOperations(denials), false, precedence));
        }
        return tuples;
    }
}

