/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;

public abstract class Permission
implements Serializable {
    private final int precedence;
    private final Set grantsAndDenials;
    private final Set grants;
    private final Set denials;

    protected Permission(int precedence, Collection grantsAndDenials) {
        if (precedence < 0 || precedence > 255) {
            precedence = -1;
        }
        this.precedence = precedence;
        HashSet<GrantAndDenial> tmpGrantsAndDenials = new HashSet<GrantAndDenial>();
        HashSet<GrantAndDenial> tmpGrants = new HashSet<GrantAndDenial>();
        HashSet<GrantAndDenial> tmpDenials = new HashSet<GrantAndDenial>();
        Iterator i = grantsAndDenials.iterator();
        while (i.hasNext()) {
            Object val = i.next();
            if (!(val instanceof GrantAndDenial)) {
                throw new IllegalArgumentException("grantsAndDenials contains a wrong element.");
            }
            GrantAndDenial gad = (GrantAndDenial)val;
            if (gad.isGrant()) {
                tmpGrants.add(gad);
            } else {
                tmpDenials.add(gad);
            }
            tmpGrantsAndDenials.add(gad);
        }
        this.grants = Collections.unmodifiableSet(tmpGrants);
        this.denials = Collections.unmodifiableSet(tmpDenials);
        this.grantsAndDenials = Collections.unmodifiableSet(tmpGrantsAndDenials);
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public Set getGrantsAndDenials() {
        return this.grantsAndDenials;
    }

    public Set getGrants() {
        return this.grants;
    }

    public Set getDenials() {
        return this.denials;
    }
}

