/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameFormDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(NameFormDescriptionSchemaParser.class);

    public synchronized NameForm parseNameFormDescription(String nameFormDescription) throws ParseException {
        LOG.debug("Parsing a NameForm : {}", (Object)nameFormDescription);
        if (nameFormDescription == null) {
            LOG.error(I18n.err((String)"ERR_04248", (Object[])new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(nameFormDescription);
        try {
            NameForm nameForm = this.parser.nameFormDescription();
            this.setSchemaName(nameForm);
            return nameForm;
        }
        catch (RecognitionException re) {
            String msg = I18n.err((String)"ERR_04249", (Object[])new Object[]{nameFormDescription, re.getMessage(), re.getColumn()});
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err((String)"ERR_04250", (Object[])new Object[]{nameFormDescription, tse.getMessage()});
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public NameForm parse(String schemaDescription) throws ParseException {
        return this.parseNameFormDescription(schemaDescription);
    }
}

